/*
 * Decompiled with CFR 0.152.
 */
package net.groupadd.yena.common.configuration.core;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.groupadd.yena.common.configuration.api.ConfigurationService;
import net.groupadd.yena.common.configuration.core.ConfigurationServiceImpl;
import net.groupadd.yena.common.configuration.core.ReloadableConfigurationServiceImpl;
import net.groupadd.yena.common.configuration.core.SourceBuilder;

public class ConfigurationServices {
    public static ConfigurationService newConfigurationService(String ... paths) {
        return ConfigurationServices.newConfigurationService(Arrays.stream(paths).collect(Collectors.toSet()));
    }

    public static ConfigurationService newConfigurationService(Set<String> paths) {
        SourceBuilder builder = SourceBuilder.builder().paths(paths).build();
        return new ConfigurationServiceImpl(builder.source());
    }

    public static ConfigurationService newReloadableConfigurationService(Function<SourceBuilder.Builder, SourceBuilder> function) {
        SourceBuilder builder = function.apply(SourceBuilder.builder());
        return new ReloadableConfigurationServiceImpl(builder.source(), builder.delay(), builder.timeUnit());
    }
}

