/*
 * Decompiled with CFR 0.152.
 */
package net.groupadd.yena.common.configuration.core;

import com.github.drapostolos.typeparser.TypeParser;
import net.groupadd.yena.common.configuration.api.Configuration;
import net.groupadd.yena.common.configuration.api.ConfigurationService;
import net.groupadd.yena.common.configuration.api.Source;
import net.groupadd.yena.common.configuration.core.ConfigurationImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationServiceImpl
implements ConfigurationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationServiceImpl.class);
    private final Source source;
    private final Configuration configuration;

    public ConfigurationServiceImpl(Source source) {
        this.source = source;
        this.configuration = new ConfigurationImpl(source, TypeParser.newBuilder().build());
    }

    @Override
    public void start() {
        this.source.init();
        LOGGER.info("Configuration loaded...");
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void stop() {
        this.source.clear();
        LOGGER.info("Configuration cleared...");
    }
}

