/*
 * Decompiled with CFR 0.152.
 */
package net.groupadd.yena.common.configuration.core;

import com.github.drapostolos.typeparser.TypeParser;
import java.util.Optional;
import net.groupadd.yena.common.configuration.api.Configuration;
import net.groupadd.yena.common.configuration.api.Source;

class ConfigurationImpl
implements Configuration {
    private final Source source;
    private final TypeParser typeParser;

    public ConfigurationImpl(Source source, TypeParser typeParser) {
        this.source = source;
        this.typeParser = typeParser;
    }

    @Override
    public String getString(String key) {
        return this.getString(key, null);
    }

    @Override
    public String getString(String key, String defaultVal) {
        return this.get(key, String.class).orElse(defaultVal);
    }

    @Override
    public Optional<Object> get(String key) {
        return Optional.ofNullable(this.source.get(key));
    }

    @Override
    public <T> Optional<T> get(String key, Class<T> type) {
        Optional<Object> optionalVal = this.get(key);
        if (optionalVal.isPresent()) {
            return Optional.of(this.typeParser.parse(optionalVal.get().toString(), type));
        }
        return Optional.empty();
    }

    @Override
    public <T> T get(String key, T defaultValue, Class<T> type) {
        return this.get(key, type).orElse(defaultValue);
    }
}

