package net.groupadd.yena.common.configuration.core;

import net.groupadd.yena.common.configuration.api.SourceLoader;
import net.groupadd.yena.common.configuration.exceptions.UnableToLoadSourceException;
import org.yaml.snakeyaml.Yaml;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

/**
 * The type Yml loader.
 */
class YmlLoaderImpl implements SourceLoader {

    private YmlLoaderImpl() {
    }

    private static class SourceLoaderHolder {
        private static final YmlLoaderImpl LOADER = new YmlLoaderImpl();
    }

    /**
     * Gets instance.
     *
     * @return the instance
     */
    public static YmlLoaderImpl getInstance() {
        return SourceLoaderHolder.LOADER;
    }

    @Override
    public Map<String, Object> load(String path) {
        try (InputStream is = new FileInputStream(path)) {
            final Yaml yaml = new Yaml();
            return yaml.load(is);
        } catch (IOException e) {
            throw new UnableToLoadSourceException("Unable to load yaml.", e);
        }
    }
}
