package net.groupadd.yena.common.configuration.core;

import net.groupadd.yena.common.configuration.api.SourceLoader;
import net.groupadd.yena.common.configuration.api.SourceLoaderFactory;
import net.groupadd.yena.common.configuration.enums.Ext;

/**
 * The type Source loader factory.
 */
class SourceLoaderFactoryImpl implements SourceLoaderFactory {

    @Override
    public SourceLoader create(final Ext ext) {
        switch (ext) {
            case YML:
            case YAML: {
                return YmlLoaderImpl.getInstance();
            }
            default: {
                return PropertiesLoaderImpl.getInstance();
            }
        }
    }
}
