package net.groupadd.yena.common.configuration.core;

import net.groupadd.yena.common.configuration.api.SourceLoader;
import net.groupadd.yena.common.configuration.exceptions.UnableToLoadSourceException;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

/**
 * The type Properties loader.
 */
class PropertiesLoaderImpl implements SourceLoader {

    private PropertiesLoaderImpl() {
    }

    private static class SourceLoaderHolder {
        private static final PropertiesLoaderImpl LOADER = new PropertiesLoaderImpl();
    }

    /**
     * Gets instance.
     *
     * @return the instance
     */
    public static PropertiesLoaderImpl getInstance() {
        return SourceLoaderHolder.LOADER;
    }

    @Override
    public Map<String, Object> load(String path) {
        try (InputStream is = new FileInputStream(path)) {
            final Properties properties = new Properties();
            properties.load(is);
            return properties.entrySet().stream().collect(
                    Collectors.toMap(
                            e -> e.getKey().toString(),
                            e -> e.getValue()
                    )
            );
        } catch (IOException e) {
            throw new UnableToLoadSourceException("Unable to load properties.", e);
        }
    }
}
