package net.groupadd.yena.common.configuration.core;

import net.groupadd.yena.common.configuration.api.ConfigurationService;

import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * The type Configuration services.
 */
public class ConfigurationServices {

    /**
     * New configuration service configuration service.
     *
     * @param paths the paths
     * @return the configuration service
     */
    public static ConfigurationService newConfigurationService(final String... paths) {
        return newConfigurationService(Arrays.stream(paths).collect(Collectors.toSet()));
    }

    /**
     * New configuration service configuration service.
     *
     * @param paths the paths
     * @return the configuration service
     */
    public static ConfigurationService newConfigurationService(final Set<String> paths) {
        final SourceBuilder builder = SourceBuilder.builder().paths(paths).build();
        return new ConfigurationServiceImpl(builder.source());
    }

    /**
     * New reloadable configuration configuration service.
     *
     * @param function the function
     * @return the configuration service
     */
    public static ConfigurationService newReloadableConfigurationService(final Function<SourceBuilder.Builder, SourceBuilder> function) {
        final SourceBuilder builder = function.apply(SourceBuilder.builder());
        return new ReloadableConfigurationServiceImpl(builder.source(), builder.delay(), builder.timeUnit());
    }

}
