package net.groupadd.yena.common.configuration.core;

import com.github.drapostolos.typeparser.TypeParser;
import net.groupadd.yena.common.configuration.api.Configuration;
import net.groupadd.yena.common.configuration.api.Source;

import java.util.Optional;

/**
 * The type Configuration.
 */
class ConfigurationImpl implements Configuration {

    private final Source source;
    private final TypeParser typeParser;

    /**
     * Instantiates a new Configuration.
     *
     * @param source     the source
     * @param typeParser the type parser
     */
    public ConfigurationImpl(final Source source, final TypeParser typeParser) {
        this.source = source;
        this.typeParser = typeParser;
    }


    @Override
    public String getString(String key) {
        return getString(key, null);
    }

    @Override
    public String getString(String key, String defaultVal) {
        return get(key, String.class).orElse(defaultVal);
    }

    @Override
    public Optional<Object> get(String key) {
        return Optional.ofNullable(this.source.get(key));
    }

    @Override
    public <T> Optional<T> get(String key, Class<T> type) {
        final Optional<Object> optionalVal = get(key);
        if (optionalVal.isPresent()) {
            return Optional.of(typeParser.parse(optionalVal.get().toString(), type));
        } else {
            return Optional.empty();
        }

    }

    @Override
    public <T> T get(String key, T defaultValue, Class<T> type) {
        return get(key, type).orElse(defaultValue);
    }
}
