package net.groupadd.yena.common.configuration.api;

import java.util.Optional;

/**
 * The interface Configuration.
 */
public interface Configuration {

    /**
     * Gets string.
     *
     * @param key the key
     * @return the string
     */
    String getString(String key);

    /**
     * Gets string.
     *
     * @param key        the key
     * @param defaultVal the default val
     * @return the string
     */
    String getString(String key, String defaultVal);

    /**
     * Get object.
     *
     * @param key the key
     * @return the object
     */
    Optional<Object> get(String key);

    /**
     * Get t.
     *
     * @param <T>  the type parameter
     * @param key  the key
     * @param type the type
     * @return the t
     */
    <T> Optional<T> get(String key, Class<T> type);


    /**
     * Get t.
     *
     * @param <T>          the type parameter
     * @param key          the key
     * @param defaultValue the default value
     * @param type         the type
     * @return the t
     */
    <T> T get(String key, T defaultValue, Class<T> type);
}
