/*
 * Decompiled with CFR 0.152.
 */
package net.groupadd.yena.common.configuration.core;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.groupadd.yena.common.configuration.enums.LoadStrategy;

final class LoaderInfo {
    private final Set<Path> paths;
    private LoadStrategy loadStrategy = LoadStrategy.IMMEDIATE;

    LoaderInfo() {
        this.paths = Collections.synchronizedSet(new HashSet());
        String vmArg = System.getProperty("config");
        if (vmArg != null) {
            for (String s : vmArg.split(",")) {
                this.paths.add(Paths.get(s, new String[0]));
            }
        }
    }

    void path(String path) {
        this.paths.add(Paths.get(path, new String[0]));
    }

    Set<Path> getPaths() {
        return this.paths;
    }

    LoadStrategy getLoadStrategy() {
        return this.loadStrategy;
    }

    public static LoaderInfo getInstatnce() {
        return SingletonHolder.single;
    }

    private static class SingletonHolder {
        static final LoaderInfo single = new LoaderInfo();

        private SingletonHolder() {
        }
    }
}

