/*
 * Decompiled with CFR 0.152.
 */
package net.groupadd.yena.common.configuration.core;

import java.util.concurrent.atomic.AtomicReference;
import net.groupadd.yena.common.configuration.api.ConfigurationLoader;
import net.groupadd.yena.common.configuration.core.LoaderInfo;
import org.cfg4j.provider.ConfigurationProvider;
import org.cfg4j.provider.ConfigurationProviderBuilder;
import org.cfg4j.source.ConfigurationSource;
import org.cfg4j.source.context.filesprovider.ConfigFilesProvider;
import org.cfg4j.source.files.FilesConfigurationSource;
import org.cfg4j.source.reload.ReloadStrategy;
import org.cfg4j.source.reload.strategy.ImmediateReloadStrategy;

class ConfigurationLoaderImpl
implements ConfigurationLoader {
    private AtomicReference<ConfigurationProvider> reference = new AtomicReference();
    private final LoaderInfo loaderInfo;

    public ConfigurationLoaderImpl(LoaderInfo loaderInfo) {
        this.loaderInfo = loaderInfo;
        this.init();
    }

    private void init() {
        switch (this.loaderInfo.getLoadStrategy()) {
            case REACTIVE: {
                this.immediatelyBuildConfigurationProvider();
                this.reactiveBuildConfigurationProvider();
                break;
            }
            case IMMEDIATE: {
                this.immediatelyBuildConfigurationProvider();
            }
        }
    }

    private void reactiveBuildConfigurationProvider() {
    }

    private void immediatelyBuildConfigurationProvider() {
        ConfigFilesProvider configFilesProvider = () -> this.loaderInfo.getPaths();
        FilesConfigurationSource source = new FilesConfigurationSource(configFilesProvider);
        ConfigurationProvider provider = new ConfigurationProviderBuilder().withConfigurationSource((ConfigurationSource)source).withReloadStrategy((ReloadStrategy)new ImmediateReloadStrategy()).build();
        this.reference.set(provider);
    }

    @Override
    public ConfigurationProvider getProvider() {
        return this.reference.get();
    }
}

