/*
 * Decompiled with CFR 0.152.
 */
package net.groupadd.yena.common.configuration.core;

import com.fasterxml.jackson.dataformat.javaprop.JavaPropsMapper;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Properties;
import net.groupadd.yena.common.configuration.api.Configuration;
import net.groupadd.yena.common.configuration.api.ConfigurationLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigurationImpl
implements Configuration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationImpl.class);
    private final ConfigurationLoader delegate;
    private final JavaPropsMapper mapper;

    ConfigurationImpl(ConfigurationLoader delegate) {
        this.delegate = delegate;
        this.mapper = new JavaPropsMapper();
    }

    @Override
    public String get(String key, String defaultValue) {
        String val = this.get(key);
        return val != null ? val : defaultValue;
    }

    @Override
    public String get(String key) {
        return (String)((Object)this.get(key, (Object)String.class));
    }

    @Override
    public <T> T get(String key, Class<T> type) {
        Object val = null;
        try {
            val = this.delegate.getProvider().getProperty(key, type);
        }
        catch (NoSuchElementException e) {
            LOGGER.warn("Not found key : " + key);
        }
        return (T)val;
    }

    @Override
    public <T> T get(String key, T defaultValue) {
        Class<?> val = this.get(key, (T)defaultValue.getClass());
        return (T)(val != null ? val : defaultValue);
    }

    @Override
    public <T> T mapToPojo(String prefix, Class<T> clz) throws IOException {
        Properties properties = new Properties();
        this.getAllAsProperties().entrySet().stream().forEach(entry -> {
            String key = (String)entry.getKey();
            if (key.startsWith(prefix)) {
                int start = prefix.length() + 1;
                properties.put(key.substring(start), entry.getValue());
            }
        });
        return (T)this.mapper.readPropertiesAs(properties, clz);
    }

    @Override
    public <T> T mapToPojo(Class<T> clz) throws IOException {
        return (T)this.mapper.readPropertiesAs(this.getAllAsProperties(), clz);
    }

    @Override
    public Properties getAllAsProperties() {
        return this.delegate.getProvider().allConfigurationAsProperties();
    }
}

