package net.groupadd.yena.common.configuration.core;

import net.groupadd.yena.common.configuration.enums.LoadStrategy;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * The type Loader info.
 */
final class LoaderInfo {

    private final Set<Path> paths;
    private LoadStrategy loadStrategy;


    /**
     * Instantiates a new Loader info.
     */
    LoaderInfo() {
        this.loadStrategy = LoadStrategy.IMMEDIATE;
        this.paths = Collections.synchronizedSet(new HashSet<>());
        final String vmArg = System.getProperty("config");
        if(vmArg!=null){
            for (String s : vmArg.split(",")) {
                this.paths.add(Paths.get(s));
            }
        }
    }

    /**
     * Path.
     *
     * @param path the path
     */
    void path(String path){
        this.paths.add(Paths.get(path));
    }

    /**
     * Gets paths.
     *
     * @return the paths
     */
    Set<Path> getPaths() {
        return paths;
    }

    /**
     * Gets load strategy.
     *
     * @return the load strategy
     */
    LoadStrategy getLoadStrategy() {
        return loadStrategy;
    }

    private static class SingletonHolder{
        /**
         * The Single.
         */
        static final LoaderInfo single = new LoaderInfo();
    }

    /**
     * Get instatnce loader info.
     *
     * @return the loader info
     */
    public static LoaderInfo getInstatnce(){
        return SingletonHolder.single;
    }

}
