package net.groupadd.yena.common.configuration.core;

import net.groupadd.yena.common.configuration.api.ConfigurationLoader;
import org.cfg4j.provider.ConfigurationProvider;
import org.cfg4j.provider.ConfigurationProviderBuilder;
import org.cfg4j.source.ConfigurationSource;
import org.cfg4j.source.context.filesprovider.ConfigFilesProvider;
import org.cfg4j.source.files.FilesConfigurationSource;
import org.cfg4j.source.reload.strategy.ImmediateReloadStrategy;

import java.util.concurrent.atomic.AtomicReference;

/**
 * The type Configuration loader.
 */
class ConfigurationLoaderImpl implements ConfigurationLoader {

    private AtomicReference<ConfigurationProvider> reference;
    private final LoaderInfo loaderInfo;

    /**
     * Instantiates a new Configuration loader.
     *
     * @param loaderInfo the loader info
     */
    public ConfigurationLoaderImpl(final LoaderInfo loaderInfo) {
        this.reference = new AtomicReference<>();
        this.loaderInfo = loaderInfo;
        init();
    }

    private void init(){
        switch (this.loaderInfo.getLoadStrategy()){
            case REACTIVE:
            {
                immediatelyBuildConfigurationProvider();
                reactiveBuildConfigurationProvider();
                break;
            }
            case IMMEDIATE:
            {
                immediatelyBuildConfigurationProvider();
                break;
            }
        }
    }

    private void reactiveBuildConfigurationProvider(){

    }

    private void immediatelyBuildConfigurationProvider(){
        final ConfigFilesProvider configFilesProvider = () -> this.loaderInfo.getPaths();
        final ConfigurationSource source = new FilesConfigurationSource(configFilesProvider);
        final org.cfg4j.provider.ConfigurationProvider provider = new ConfigurationProviderBuilder().withConfigurationSource(source).withReloadStrategy(new ImmediateReloadStrategy()).build();
        this.reference.set(provider);
    }

    @Override
    public ConfigurationProvider getProvider() {
        return reference.get();
    }
}
