package net.groupadd.yena.common.configuration.core;

import com.google.inject.AbstractModule;
import net.groupadd.yena.common.configuration.api.Configuration;

import java.util.HashSet;
import java.util.Set;

/**
 * The type Common config module.
 */
public class CommonConfigModule extends AbstractModule {

    private final Set<String> paths;

    /**
     * Instantiates a new Common config module.
     */
    public CommonConfigModule() {
        this.paths = new HashSet<>();
    }

    /**
     * Instantiates a new Common config module.
     *
     * @param absolutePaths the absolute paths
     */
    public CommonConfigModule(final String...absolutePaths) {
        this();
        for (String s : absolutePaths) {
            paths.add(s);
        }
    }

    @Override
    protected void configure() {
        bind(Configuration.class).toInstance(Config.of(paths.toArray(new String[paths.size()])));
    }


}
