/*
 * Decompiled with CFR 0.152.
 */
package net.groupadd.yena.common.configuration.impl;

import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.groupadd.yena.common.configuration.api.Configuration;
import net.groupadd.yena.common.configuration.api.Provider;
import net.groupadd.yena.common.configuration.impl.ConfigurationLoaderInfoProvider;
import org.cfg4j.provider.ConfigurationProviderBuilder;
import org.cfg4j.source.ConfigurationSource;
import org.cfg4j.source.context.filesprovider.ConfigFilesProvider;
import org.cfg4j.source.files.FilesConfigurationSource;
import org.cfg4j.source.reload.ReloadStrategy;
import org.cfg4j.source.reload.strategy.ImmediateReloadStrategy;
import org.cfg4j.source.reload.strategy.PeriodicalReloadStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationProvider
implements Provider<Configuration> {
    private static final Logger log = LoggerFactory.getLogger(ConfigurationProvider.class);
    private Configuration configuration;

    private ConfigurationProvider() {
        this.load();
    }

    public static ConfigurationProvider getInstance() {
        return SingletonHolder.PROVIDER;
    }

    private void load() {
        ConfigurationLoaderInfoProvider.LoaderInfo loaderInfo = ConfigurationLoaderInfoProvider.getInstance().get();
        int period = loaderInfo.getPeriod();
        TimeUnit timeUnit = loaderInfo.getTimeUnit();
        Set<Path> paths = loaderInfo.getSet();
        ConfigFilesProvider configFilesProvider = () -> paths;
        FilesConfigurationSource source = new FilesConfigurationSource(configFilesProvider);
        ConfigurationProviderBuilder builder = new ConfigurationProviderBuilder().withConfigurationSource((ConfigurationSource)source);
        org.cfg4j.provider.ConfigurationProvider provider = period > 0 ? builder.withReloadStrategy((ReloadStrategy)new PeriodicalReloadStrategy((long)period, timeUnit)).build() : builder.withReloadStrategy((ReloadStrategy)new ImmediateReloadStrategy()).build();
        this.configuration = new ConfigurationImpl(provider);
    }

    @Override
    public Configuration get() {
        return this.configuration;
    }

    class ConfigurationImpl
    implements Configuration {
        private final org.cfg4j.provider.ConfigurationProvider delegate;

        private ConfigurationImpl(org.cfg4j.provider.ConfigurationProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public String get(String key, String defaultValue) {
            String val = this.get(key);
            return val != null ? val : defaultValue;
        }

        @Override
        public String get(String key) {
            return (String)((Object)this.get(key, (Object)String.class));
        }

        @Override
        public <T> T get(String key, Class<T> type) {
            Object val = null;
            try {
                val = this.delegate.getProperty(key, type);
            }
            catch (NoSuchElementException e) {
                log.warn("Not found key : " + key);
            }
            return (T)val;
        }

        @Override
        public <T> T get(String key, T defaultValue) {
            Class<?> val = this.get(key, (T)defaultValue.getClass());
            return (T)(val != null ? val : defaultValue);
        }

        @Override
        public <T> T mapToInterface(String prefix, Class<T> clz) {
            return (T)this.delegate.bind(prefix, clz);
        }

        @Override
        public Properties getAllAsProperties() {
            return this.delegate.allConfigurationAsProperties();
        }
    }

    private static class SingletonHolder {
        static final ConfigurationProvider PROVIDER = new ConfigurationProvider();

        private SingletonHolder() {
        }
    }
}

