/*
 * Decompiled with CFR 0.152.
 */
package net.groupadd.yena.common.configuration.impl;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.groupadd.yena.common.configuration.api.Provider;

class ConfigurationLoaderInfoProvider
implements Provider<LoaderInfo> {
    private final LoaderInfo loaderInfo = new LoaderInfo();

    private ConfigurationLoaderInfoProvider() {
    }

    public static ConfigurationLoaderInfoProvider getInstance() {
        return SingletonHolder.SINGLE;
    }

    @Override
    public LoaderInfo get() {
        return this.loaderInfo;
    }

    class LoaderInfo {
        private int period;
        private TimeUnit timeUnit;
        private Set<Path> set = new HashSet<Path>();

        private LoaderInfo() {
            this.timeUnit = TimeUnit.HOURS;
        }

        int getPeriod() {
            return this.period;
        }

        Set<Path> getSet() {
            return this.set;
        }

        TimeUnit getTimeUnit() {
            return this.timeUnit;
        }

        public void setTimeUnit(TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }

        public void addPath(Path path) {
            this.set.add(path);
        }

        public void setPeriod(int period) {
            this.period = period;
        }
    }

    private static class SingletonHolder {
        static final ConfigurationLoaderInfoProvider SINGLE = new ConfigurationLoaderInfoProvider();

        private SingletonHolder() {
        }
    }
}

