/*
 * Decompiled with CFR 0.152.
 */
package net.groupadd.yena.common.configuration.impl;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import net.groupadd.yena.common.configuration.impl.ConfigurationLoaderInfoProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurationPathRegister {
    private static final Logger log = LoggerFactory.getLogger(AbstractConfigurationPathRegister.class);
    private final ConfigurationLoaderInfoProvider.LoaderInfo loaderInfo = ConfigurationLoaderInfoProvider.getInstance().get();
    private static final String DEFAULT_SYSTEM_PROPERTY_KEY = "config";
    private static final String CONFIG_PATH_DELIMITER = ",";

    protected AbstractConfigurationPathRegister() {
        this.addSystemPropertyKey(DEFAULT_SYSTEM_PROPERTY_KEY);
    }

    protected AbstractConfigurationPathRegister(int period, TimeUnit unit) {
        this();
        this.loaderInfo.setPeriod(period);
        this.loaderInfo.setTimeUnit(unit);
    }

    protected abstract void configure();

    protected void addPath(String ... absoluteFilePaths) {
        for (String path : absoluteFilePaths) {
            this.addPath(path);
        }
    }

    protected void addPath(String absoluteFilePath) {
        Path path = Paths.get(absoluteFilePath, new String[0]);
        this.loaderInfo.addPath(path);
    }

    protected void addSystemPropertyKey(String key) {
        Optional<String> optional = Optional.ofNullable(System.getProperty(key));
        if (optional.isPresent()) {
            this.addPath(optional.get().split(CONFIG_PATH_DELIMITER));
        } else if (!DEFAULT_SYSTEM_PROPERTY_KEY.equals(key)) {
            log.info("Not found system property value of the key : " + key);
        }
    }
}

