package net.groupadd.yena.common.configuration.impl;

import net.groupadd.yena.common.configuration.api.Provider;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

/**
 * The type Configuration loader info provider.
 */
class ConfigurationLoaderInfoProvider implements Provider<ConfigurationLoaderInfoProvider.LoaderInfo> {

    private final LoaderInfo loaderInfo;

    private ConfigurationLoaderInfoProvider() {
        this.loaderInfo = new LoaderInfo();
    }

    private static class SingletonHolder {
        /**
         * The Single.
         */
        static final ConfigurationLoaderInfoProvider SINGLE = new ConfigurationLoaderInfoProvider();
    }

    /**
     * Gets instance.
     *
     * @return the instance
     */
    public static ConfigurationLoaderInfoProvider getInstance() {
        return SingletonHolder.SINGLE;
    }

    @Override
    public LoaderInfo get() {
        return this.loaderInfo;
    }

    /**
     * The type Loader info.
     */
    class LoaderInfo {
        private int period;
        private TimeUnit timeUnit;
        private Set<Path> set;

        private LoaderInfo() {
            this.set = new HashSet<>();
            this.timeUnit = TimeUnit.HOURS;
        }

        /**
         * Gets period.
         *
         * @return the period
         */
        int getPeriod() {
            return period;
        }

        /**
         * Gets set.
         *
         * @return the set
         */
        Set<Path> getSet() {
            return set;
        }

        /**
         * Gets time unit.
         *
         * @return the time unit
         */
        TimeUnit getTimeUnit() {
            return timeUnit;
        }

        /**
         * Sets time unit.
         *
         * @param timeUnit the time unit
         */
        public void setTimeUnit(final TimeUnit timeUnit) {
            this.timeUnit = timeUnit;
        }

        /**
         * Add path.
         *
         * @param path the path
         */
        public void addPath(final Path path) {
            this.set.add(path);
        }

        /**
         * Sets period.
         *
         * @param period the period
         */
        public void setPeriod(final int period) {
            this.period = period;
        }
    }
}
