package net.groupadd.yena.common.configuration.api;

import java.util.Properties;

/**
 * The interface Configuration.
 */
public interface Configuration {
    /**
     * Get string.
     *
     * @param key          the key
     * @param defaultValue the default value
     * @return the string
     */
    String get(String key, String defaultValue);

    /**
     * Get string.
     *
     * @param key the key
     * @return the string
     */
    String get(String key);

    /**
     * Get t.
     *
     * @param <T>  the type parameter
     * @param key  the key
     * @param type the type
     * @return the t
     */
    <T> T get(String key, Class<T> type);

    /**
     * Get t.
     *
     * @param <T>          the type parameter
     * @param key          the key
     * @param defaultValue the default value
     * @return the t
     */
    <T> T get(String key, T defaultValue);

    /**
     * Map to interface t.
     *
     * @param <T>    the type parameter
     * @param prefix the prefix
     * @param clz    the clz
     * @return the t
     */
    <T> T mapToInterface(String prefix, Class<T> clz);

    /**
     * Gets all as properties.
     *
     * @return the all as properties
     */
    Properties getAllAsProperties();
}
