/*
 * Decompiled with CFR 0.152.
 */
package net.golbarg.pdfviewer;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Base64;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.scene.Parent;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import net.golbarg.pdfviewer.JavaSriptLogListener;
import net.golbarg.pdfviewer.PDFJSVersion;
import netscape.javascript.JSObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFViewer {
    private static final Logger logger = LoggerFactory.getLogger(PDFViewer.class);
    public static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool(runnable -> {
        Thread t = new Thread(runnable);
        t.setDaemon(true);
        return t;
    });
    public final ObjectProperty<Consumer<Task<String>>> onLoaderTaskPresent = new SimpleObjectProperty();
    private boolean pdfJsLoaded;
    private final PDFJSVersion version;
    private WebView webView;
    private String loadScript;
    private String toExecuteWhenPDFJSLoaded = "";

    public PDFViewer(PDFJSVersion version) {
        this.version = version;
    }

    public PDFViewer() {
        this(PDFJSVersion.latestVersion());
    }

    public PDFViewer(PDFJSVersion version, File file) throws IOException {
        this(version);
        this.loadPDF(file);
    }

    public PDFViewer(File file) throws IOException {
        this(PDFJSVersion.latestVersion(), file);
    }

    public PDFViewer(PDFJSVersion version, URL url) throws IOException {
        this(version);
        this.loadPDF(url);
    }

    public PDFViewer(URL url) throws IOException {
        this(PDFJSVersion.latestVersion(), url);
    }

    public PDFViewer(PDFJSVersion version, InputStream inputStream) throws IOException {
        this(version);
        this.loadPDF(inputStream);
    }

    public PDFViewer(InputStream inputStream) throws IOException {
        this(PDFJSVersion.latestVersion(), inputStream);
    }

    @Deprecated
    public void displayPdf(File file) throws IOException {
        this.loadPDF(file);
    }

    @Deprecated
    public void displayPdf(URL url) throws IOException {
        this.loadPDF(url);
    }

    @Deprecated
    public void displayPdf(InputStream inputStream) throws IOException {
        this.loadPDF(inputStream);
    }

    public void loadPDF(File file) throws IOException {
        this.loadPDF(new BufferedInputStream(new FileInputStream(file)));
    }

    public void loadPDF(URL url) throws IOException {
        this.loadPDF(new BufferedInputStream(url.openConnection().getInputStream()));
    }

    public void loadPDF(InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        Task<String> task = this.buildLoadingTask(inputStream);
        Consumer onLoaderTaskPresent = (Consumer)this.onLoaderTaskPresent.get();
        if (onLoaderTaskPresent != null) {
            Platform.runLater(() -> onLoaderTaskPresent.accept(task));
        }
        THREAD_POOL.submit((Runnable)task);
    }

    private Task<String> buildLoadingTask(final InputStream inputStream) {
        Task<String> task = new Task<String>(){

            /*
             * Loose catch block
             */
            protected String call() throws Exception {
                try {
                    try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                        int bytesRead;
                        long contentSize = inputStream.available();
                        long onePercent = contentSize / 100L;
                        int allReadBytesCount = 0;
                        byte[] buf = new byte[4096];
                        while ((bytesRead = inputStream.read(buf)) >= 0) {
                            allReadBytesCount += bytesRead;
                            outputStream.write(buf, 0, bytesRead);
                            if (onePercent > 0L) {
                                double percent = (double)allReadBytesCount / (double)onePercent;
                                this.updateProgress(percent, 100.0);
                            }
                            if (!this.isCancelled()) continue;
                            String percent = null;
                            return percent;
                        }
                        byte[] data = outputStream.toByteArray();
                        String base64 = Base64.getEncoder().encodeToString(data);
                        String string = "openFileFromBase64('" + base64 + "');";
                        return string;
                    }
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    inputStream.close();
                }
            }
        };
        task.valueProperty().addListener((observable, oldValue, js) -> {
            block3: {
                if (js != null) {
                    try {
                        this.webView.getEngine().executeScript(js);
                    }
                    catch (Exception ex) {
                        if (this.pdfJsLoaded) break block3;
                        this.loadScript = js;
                    }
                }
            }
        });
        return task;
    }

    public void setSecondaryToolbarToggleVisibility(boolean value) {
        block2: {
            this.setVisibilityOf("secondaryToolbarToggle", value);
            String js = value ? "var element = document.getElementsByClassName('verticalToolbarSeparator')[0];" + "element.style.display = 'inherit';" + "element.style.visibility = 'inherit';" : "var element = document.getElementsByClassName('verticalToolbarSeparator')[0];" + "element.style.display = 'none';" + "element.style.visibility = 'hidden';";
            try {
                this.webView.getEngine().executeScript(js);
            }
            catch (Exception exception) {
                if (this.pdfJsLoaded) break block2;
                this.toExecuteWhenPDFJSLoaded = this.toExecuteWhenPDFJSLoaded + js;
            }
        }
    }

    public void setVisibilityOf(String id, boolean value) {
        block2: {
            String css = value ? "document.getElementById('" + id + "').style.display = 'inherit';" + ("document.getElementById('" + id + "').style.visibility = 'inherit';") : "document.getElementById('" + id + "').style.display = 'none';" + ("document.getElementById('" + id + "').style.visibility = 'hidden';");
            try {
                this.webView.getEngine().executeScript(css);
            }
            catch (Exception ex) {
                if (this.pdfJsLoaded) break block2;
                this.toExecuteWhenPDFJSLoaded = this.toExecuteWhenPDFJSLoaded + css;
            }
        }
    }

    public int getActualPageNumber() {
        try {
            return (Integer)this.webView.getEngine().executeScript("PDFViewerApplication.page;");
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getTotalPageCount() {
        try {
            return (Integer)this.webView.getEngine().executeScript("PDFViewerApplication.pagesCount;");
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void navigateByPage(int pageNum) {
        block2: {
            String jsCommand = "goToPage(" + pageNum + ");";
            try {
                this.webView.getEngine().executeScript(jsCommand);
            }
            catch (Exception ex) {
                if (this.pdfJsLoaded) break block2;
                this.toExecuteWhenPDFJSLoaded = this.toExecuteWhenPDFJSLoaded + jsCommand;
            }
        }
    }

    public void executeScript(String js) {
        block2: {
            try {
                this.webView.getEngine().executeScript(js);
            }
            catch (Exception ex) {
                if (this.pdfJsLoaded) break block2;
                this.toExecuteWhenPDFJSLoaded = this.toExecuteWhenPDFJSLoaded + String.format("%s;", js);
            }
        }
    }

    private WebView createWebView() {
        WebView webView = new WebView();
        webView.setContextMenuEnabled(false);
        final WebEngine engine = webView.getEngine();
        String url = this.getClass().getResource(this.version.getPath()).toExternalForm();
        engine.setJavaScriptEnabled(true);
        engine.load(url);
        engine.getLoadWorker().stateProperty().addListener((ChangeListener)new ChangeListener<Worker.State>(){

            public void changed(ObservableValue<? extends Worker.State> observable, Worker.State oldValue, Worker.State newValue) {
                JSObject window = (JSObject)engine.executeScript("window");
                window.setMember("java", new JavaSriptLogListener());
                engine.executeScript("console.log = function(message){ try {java.log(message);} catch(e) {} };");
                if (newValue == Worker.State.SUCCEEDED) {
                    try {
                        PDFViewer.this.pdfJsLoaded = true;
                        if (PDFViewer.this.loadScript != null) {
                            logger.debug("PDF already loaded");
                            engine.executeScript(PDFViewer.this.loadScript);
                        }
                        engine.executeScript(PDFViewer.this.toExecuteWhenPDFJSLoaded);
                        PDFViewer.this.toExecuteWhenPDFJSLoaded = null;
                        observable.removeListener((ChangeListener)this);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
        return webView;
    }

    public Parent toNode() {
        if (this.webView == null) {
            this.webView = this.createWebView();
            return this.webView;
        }
        return this.webView;
    }

    public Consumer<Task<String>> getOnLoaderTaskPresent() {
        return (Consumer)this.onLoaderTaskPresent.get();
    }

    public ObjectProperty<Consumer<Task<String>>> onLoaderTaskPresentProperty() {
        return this.onLoaderTaskPresent;
    }

    public void setOnLoaderTaskPresent(Consumer<Task<String>> onLoaderTaskPresent) {
        this.onLoaderTaskPresent.set(onLoaderTaskPresent);
    }
}

