/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.locales;

import co.aikar.locales.LanguageTable;
import co.aikar.locales.MessageKey;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Function;
import javax.annotation.Nullable;

public class LocaleManager<T> {
    private final Function<T, Locale> localeMapper;
    private final Map<Locale, LanguageTable> tables = new HashMap<Locale, LanguageTable>();
    private Locale defaultLocale;

    LocaleManager(Function<T, Locale> localeMapper, Locale defaultLocale) {
        this.localeMapper = localeMapper;
        this.defaultLocale = defaultLocale;
    }

    public static <T> LocaleManager<T> create(Function<T, Locale> localeMapper) {
        return new LocaleManager<T>(localeMapper, Locale.ENGLISH);
    }

    public static <T> LocaleManager<T> create(Function<T, Locale> localeMapper, Locale defaultLocale) {
        return new LocaleManager<T>(localeMapper, defaultLocale);
    }

    public Locale setDefaultLocale(Locale defaultLocale) {
        Locale previous = this.defaultLocale;
        this.defaultLocale = defaultLocale;
        return previous;
    }

    public boolean addMessageBundle(String bundleName, Locale ... locales) {
        return this.addMessageBundle(Thread.currentThread().getContextClassLoader(), bundleName, locales);
    }

    public boolean addMessageBundle(ClassLoader classLoader, String bundleName, Locale ... locales) {
        if (locales.length == 0) {
            locales = new Locale[]{this.defaultLocale};
        }
        boolean found = false;
        for (Locale locale : locales) {
            if (!this.getTable(locale).addMessageBundle(classLoader, bundleName)) continue;
            found = true;
        }
        return found;
    }

    public void addMessages(Locale locale, Map<MessageKey, String> messages) {
        this.getTable(locale).addMessages(messages);
    }

    public String addMessage(Locale locale, MessageKey key, String message) {
        return this.getTable(locale).addMessage(key, message);
    }

    @Nullable
    public String getMessage(T context, MessageKey key) {
        Locale locale = this.localeMapper.apply(context);
        String message = this.getTable(locale).getMessage(key);
        if (message == null && !locale.getCountry().isEmpty()) {
            message = this.getTable(new Locale(locale.getLanguage())).getMessage(key);
        }
        if (message == null && !Objects.equals(locale, this.defaultLocale)) {
            message = this.getTable(this.defaultLocale).getMessage(key);
        }
        return message;
    }

    public LanguageTable getTable(Locale locale) {
        return this.tables.computeIfAbsent(locale, LanguageTable::new);
    }

    public boolean addResourceBundle(ResourceBundle bundle, Locale locale) {
        return this.getTable(locale).addResourceBundle(bundle);
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }
}

