/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFSpongeListener;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandCompletionContext;
import co.aikar.commands.CommandCompletions;
import co.aikar.commands.CommandContexts;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.CommandOperationContext;
import co.aikar.commands.CommandParameter;
import co.aikar.commands.LogLevel;
import co.aikar.commands.MessageType;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.RootCommand;
import co.aikar.commands.SpongeCommandCompletionContext;
import co.aikar.commands.SpongeCommandCompletions;
import co.aikar.commands.SpongeCommandContexts;
import co.aikar.commands.SpongeCommandExecutionContext;
import co.aikar.commands.SpongeCommandIssuer;
import co.aikar.commands.SpongeCommandOperationContext;
import co.aikar.commands.SpongeConditionContext;
import co.aikar.commands.SpongeLocales;
import co.aikar.commands.SpongeMessageFormatter;
import co.aikar.commands.SpongeRegisteredCommand;
import co.aikar.commands.SpongeRootCommand;
import co.aikar.commands.apachecommonslang.ApacheCommonsExceptionUtil;
import co.aikar.timings.Timing;
import co.aikar.timings.Timings;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.plugin.PluginContainer;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextColors;

public class SpongeCommandManager
extends CommandManager<CommandSource, SpongeCommandIssuer, TextColor, SpongeMessageFormatter, SpongeCommandExecutionContext, SpongeConditionContext> {
    protected final PluginContainer plugin;
    protected Map<String, SpongeRootCommand> registeredCommands = new HashMap<String, SpongeRootCommand>();
    protected SpongeCommandContexts contexts;
    protected SpongeCommandCompletions completions;
    private Timing commandTiming;
    protected SpongeLocales locales;

    public SpongeCommandManager(PluginContainer plugin) {
        this.plugin = plugin;
        String pluginName = "acf-" + plugin.getName();
        this.getLocales().addMessageBundles("acf-minecraft", pluginName, pluginName.toLowerCase(Locale.ENGLISH));
        this.commandTiming = Timings.of((Object)plugin, (String)"Commands");
        this.defaultFormatter = new SpongeMessageFormatter(TextColors.RED, TextColors.YELLOW, TextColors.RED);
        this.formatters.put(MessageType.ERROR, this.defaultFormatter);
        this.formatters.put(MessageType.SYNTAX, new SpongeMessageFormatter(TextColors.YELLOW, TextColors.GREEN, TextColors.WHITE));
        this.formatters.put(MessageType.INFO, new SpongeMessageFormatter(TextColors.BLUE, TextColors.DARK_GREEN, TextColors.GREEN));
        this.formatters.put(MessageType.HELP, new SpongeMessageFormatter(TextColors.AQUA, TextColors.GREEN, TextColors.YELLOW));
        this.getLocales();
        Sponge.getEventManager().registerListeners((Object)plugin, (Object)new ACFSpongeListener(this));
        this.registerDependency(plugin.getClass(), plugin);
    }

    public PluginContainer getPlugin() {
        return this.plugin;
    }

    @Override
    public boolean isCommandIssuer(Class<?> type) {
        return CommandSource.class.isAssignableFrom(type);
    }

    @Override
    public synchronized CommandContexts<SpongeCommandExecutionContext> getCommandContexts() {
        if (this.contexts == null) {
            this.contexts = new SpongeCommandContexts(this);
        }
        return this.contexts;
    }

    @Override
    public synchronized CommandCompletions<SpongeCommandCompletionContext> getCommandCompletions() {
        if (this.completions == null) {
            this.completions = new SpongeCommandCompletions(this);
        }
        return this.completions;
    }

    @Override
    public SpongeLocales getLocales() {
        if (this.locales == null) {
            this.locales = new SpongeLocales(this);
            this.locales.loadLanguages();
        }
        return this.locales;
    }

    @Override
    public boolean hasRegisteredCommands() {
        return !this.registeredCommands.isEmpty();
    }

    @Override
    public void registerCommand(BaseCommand command) {
        command.onRegister(this);
        for (Map.Entry<String, RootCommand> entry : command.registeredCommands.entrySet()) {
            String commandName = entry.getKey().toLowerCase(Locale.ENGLISH);
            SpongeRootCommand spongeCommand = (SpongeRootCommand)entry.getValue();
            if (!spongeCommand.isRegistered) {
                Sponge.getCommandManager().register((Object)this.plugin, (CommandCallable)spongeCommand, new String[]{commandName});
            }
            spongeCommand.isRegistered = true;
            this.registeredCommands.put(commandName, spongeCommand);
        }
    }

    public Timing createTiming(String name) {
        return Timings.of((Object)this.plugin, (String)name, (Timing)this.commandTiming);
    }

    @Override
    public RootCommand createRootCommand(String cmd) {
        return new SpongeRootCommand(this, cmd);
    }

    @Override
    public Collection<RootCommand> getRegisteredRootCommands() {
        return Collections.unmodifiableCollection(this.registeredCommands.values());
    }

    @Override
    public SpongeCommandIssuer getCommandIssuer(Object issuer) {
        if (!(issuer instanceof CommandSource)) {
            throw new IllegalArgumentException(issuer.getClass().getName() + " is not a Command Issuer.");
        }
        return new SpongeCommandIssuer(this, (CommandSource)issuer);
    }

    @Override
    public SpongeCommandExecutionContext createCommandContext(RegisteredCommand command, CommandParameter parameter, CommandIssuer sender, List<String> args, int i, Map<String, Object> passedArgs) {
        return new SpongeCommandExecutionContext(command, parameter, (SpongeCommandIssuer)sender, args, i, passedArgs);
    }

    @Override
    public CommandCompletionContext createCompletionContext(RegisteredCommand command, CommandIssuer sender, String input, String config, String[] args) {
        return new SpongeCommandCompletionContext(command, (SpongeCommandIssuer)sender, input, config, args);
    }

    @Override
    public RegisteredCommand createRegisteredCommand(BaseCommand command, String cmdName, Method method, String prefSubCommand) {
        return new SpongeRegisteredCommand(command, cmdName, method, prefSubCommand);
    }

    @Override
    public void log(LogLevel level, String message, Throwable throwable) {
        Logger logger = this.plugin.getLogger();
        switch (level) {
            case INFO: {
                logger.info("[ACF] " + message);
                if (throwable != null) {
                    for (String line : ACFPatterns.NEWLINE.split(ApacheCommonsExceptionUtil.getFullStackTrace(throwable))) {
                        logger.info("[ACF] " + line);
                    }
                }
                return;
            }
            case ERROR: {
                logger.error("[ACF] " + message);
                if (throwable == null) break;
                for (String line : ACFPatterns.NEWLINE.split(ApacheCommonsExceptionUtil.getFullStackTrace(throwable))) {
                    logger.error("[ACF] " + line);
                }
                break;
            }
        }
    }

    @Override
    CommandOperationContext createCommandOperationContext(BaseCommand command, CommandIssuer issuer, String commandLabel, String[] args, boolean isAsync) {
        return new SpongeCommandOperationContext((CommandManager)this, issuer, command, commandLabel, args, isAsync);
    }

    @Override
    public SpongeConditionContext createConditionContext(CommandIssuer issuer, String config) {
        return new SpongeConditionContext((SpongeCommandIssuer)issuer, config);
    }

    @Override
    public String getCommandPrefix(CommandIssuer issuer) {
        return issuer.isPlayer() ? "/" : "";
    }
}

