/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.MinecraftMessageKeys;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.Entity;
import org.spongepowered.api.entity.living.player.Player;

public class ACFSpongeUtil {
    public static Player findPlayerSmart(CommandIssuer issuer, String search) {
        CommandSource requester = (CommandSource)issuer.getIssuer();
        if (search == null) {
            return null;
        }
        String name = ACFUtil.replace(search, ":confirm", "");
        if (!ACFSpongeUtil.isValidName(name)) {
            issuer.sendError(MinecraftMessageKeys.IS_NOT_A_VALID_NAME, "{name}", name);
            return null;
        }
        List<Player> matches = ACFSpongeUtil.matchPlayer(name);
        ArrayList<Player> confirmList = new ArrayList<Player>();
        ACFSpongeUtil.findMatches(search, requester, matches, confirmList);
        if (matches.size() > 1 || confirmList.size() > 1) {
            String allMatches = matches.stream().map(CommandSource::getName).collect(Collectors.joining(", "));
            issuer.sendError(MinecraftMessageKeys.MULTIPLE_PLAYERS_MATCH, "{search}", name, "{all}", allMatches);
            return null;
        }
        if (matches.isEmpty()) {
            Player player = ACFUtil.getFirstElement(confirmList);
            if (player == null) {
                issuer.sendError(MinecraftMessageKeys.NO_PLAYER_FOUND_SERVER, "{search}", name);
                return null;
            }
            issuer.sendInfo(MinecraftMessageKeys.PLAYER_IS_VANISHED_CONFIRM, "{vanished}", player.getName());
            return null;
        }
        return matches.get(0);
    }

    private static void findMatches(String search, CommandSource requester, List<Player> matches, List<Player> confirmList) {
        Iterator<Player> iter = matches.iterator();
        while (iter.hasNext()) {
            Player player = iter.next();
            if (!(requester instanceof Player) || ((Player)requester).canSee((Entity)player)) continue;
            if (requester.hasPermission("acf.seevanish")) {
                if (search.endsWith(":confirm")) continue;
                confirmList.add(player);
                iter.remove();
                continue;
            }
            iter.remove();
        }
    }

    public static List<Player> matchPlayer(String partialName) {
        ArrayList<Player> matchedPlayers = new ArrayList<Player>();
        for (Player iterPlayer : Sponge.getServer().getOnlinePlayers()) {
            String iterPlayerName = iterPlayer.getName();
            if (partialName.equalsIgnoreCase(iterPlayerName)) {
                matchedPlayers.clear();
                matchedPlayers.add(iterPlayer);
                break;
            }
            if (!iterPlayerName.toLowerCase(Locale.ENGLISH).contains(partialName.toLowerCase(Locale.ENGLISH))) continue;
            matchedPlayers.add(iterPlayer);
        }
        return matchedPlayers;
    }

    public static boolean isValidName(String name) {
        return name != null && !name.isEmpty() && ACFPatterns.VALID_NAME_PATTERN.matcher(name).matches();
    }
}

