/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.RootCommand;
import co.aikar.commands.SpongeCommandManager;
import co.aikar.commands.SpongeCommandOperationContext;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.api.command.CommandCallable;
import org.spongepowered.api.command.CommandException;
import org.spongepowered.api.command.CommandResult;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.world.Location;
import org.spongepowered.api.world.World;

public class SpongeRootCommand
implements CommandCallable,
RootCommand {
    private final SpongeCommandManager manager;
    private final String name;
    private BaseCommand defCommand;
    private SetMultimap<String, RegisteredCommand> subCommands = HashMultimap.create();
    private List<BaseCommand> children = new ArrayList<BaseCommand>();
    boolean isRegistered = false;

    SpongeRootCommand(SpongeCommandManager manager, String name) {
        this.manager = manager;
        this.name = name;
    }

    @Override
    public String getCommandName() {
        return this.name;
    }

    public CommandResult process(@NotNull CommandSource source, @NotNull String arguments) throws CommandException {
        String[] args = arguments.isEmpty() ? new String[]{} : arguments.split(" ");
        return this.executeSponge(this.manager.getCommandIssuer(source), this.name, args);
    }

    public List<String> getSuggestions(@NotNull CommandSource source, @NotNull String arguments, @Nullable Location<World> location) throws CommandException {
        String[] stringArray;
        if (arguments.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = arguments.split(" ");
        }
        String[] args = stringArray;
        return this.getTabCompletions(this.manager.getCommandIssuer(source), this.name, args);
    }

    public boolean testPermission(@NotNull CommandSource source) {
        return this.hasAnyPermission(this.manager.getCommandIssuer(source));
    }

    public Optional<Text> getShortDescription(@NotNull CommandSource source) {
        String description = this.getDescription();
        return description != null ? Optional.of(Text.of((String)description)) : Optional.empty();
    }

    public Optional<Text> getHelp(@NotNull CommandSource source) {
        return Optional.empty();
    }

    public Text getUsage(@NotNull CommandSource source) {
        String usage = this.getUsage();
        return usage != null ? Text.of((String)usage) : Text.of();
    }

    private CommandResult executeSponge(CommandIssuer sender, String commandLabel, String[] args) {
        BaseCommand cmd = this.execute(sender, commandLabel, args);
        SpongeCommandOperationContext lastContext = (SpongeCommandOperationContext)cmd.getLastCommandOperationContext();
        return lastContext != null ? lastContext.getResult() : CommandResult.success();
    }

    @Override
    public void addChild(BaseCommand command) {
        if (this.defCommand == null || !command.subCommands.get((Object)"__default").isEmpty()) {
            this.defCommand = command;
        }
        this.addChildShared(this.children, this.subCommands, command);
    }

    @Override
    public BaseCommand getDefCommand() {
        return this.defCommand;
    }

    @Override
    public CommandManager getManager() {
        return this.manager;
    }

    @Override
    public SetMultimap<String, RegisteredCommand> getSubCommands() {
        return this.subCommands;
    }

    @Override
    public List<BaseCommand> getChildren() {
        return this.children;
    }
}

