/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.ACFSpongeUtil;
import co.aikar.commands.ACFUtil;
import co.aikar.commands.CommandContexts;
import co.aikar.commands.InvalidCommandArgument;
import co.aikar.commands.LogLevel;
import co.aikar.commands.MessageKeys;
import co.aikar.commands.MinecraftMessageKeys;
import co.aikar.commands.SpongeCommandExecutionContext;
import co.aikar.commands.SpongeCommandIssuer;
import co.aikar.commands.SpongeCommandManager;
import co.aikar.commands.contexts.CommandResultSupplier;
import co.aikar.commands.contexts.OnlinePlayer;
import co.aikar.locales.MessageKeyProvider;
import java.util.HashSet;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.command.CommandSource;
import org.spongepowered.api.entity.living.player.Player;
import org.spongepowered.api.entity.living.player.User;
import org.spongepowered.api.service.user.UserStorageService;
import org.spongepowered.api.text.format.TextColor;
import org.spongepowered.api.text.format.TextStyle;
import org.spongepowered.api.world.World;

public class SpongeCommandContexts
extends CommandContexts<SpongeCommandExecutionContext> {
    public SpongeCommandContexts(SpongeCommandManager manager) {
        super(manager);
        this.registerIssuerOnlyContext(CommandResultSupplier.class, c -> new CommandResultSupplier());
        this.registerContext(co.aikar.commands.sponge.contexts.OnlinePlayer.class, c -> this.getOnlinePlayer((SpongeCommandIssuer)c.getIssuer(), c.popFirstArg(), c.isOptional()));
        this.registerContext(OnlinePlayer.class, c -> {
            co.aikar.commands.sponge.contexts.OnlinePlayer onlinePlayer = this.getOnlinePlayer((SpongeCommandIssuer)c.getIssuer(), c.popFirstArg(), c.isOptional());
            return onlinePlayer != null ? new OnlinePlayer(onlinePlayer.getPlayer()) : null;
        });
        this.registerContext(User.class, c -> {
            String name = c.popFirstArg();
            Optional targetPlayer = Sponge.getGame().getServer().getPlayer(name);
            if (targetPlayer.isPresent()) {
                return (User)targetPlayer.get();
            }
            Optional service = Sponge.getGame().getServiceManager().provide(UserStorageService.class);
            if (!service.isPresent()) {
                manager.log(LogLevel.ERROR, "No UserStorageService is available", new Error());
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.ERROR_GENERIC_LOGGED, false, new String[0]);
            }
            Optional user = ((UserStorageService)service.get()).get(name);
            if (user.isPresent()) {
                return (User)user.get();
            }
            if (!c.isOptional()) {
                throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.NO_PLAYER_FOUND, false, "{search}", name);
            }
            return null;
        });
        this.registerContext(TextColor.class, c -> {
            String first = c.popFirstArg();
            Stream<Object> colours = Sponge.getRegistry().getAllOf(TextColor.class).stream();
            String filter = c.getFlagValue("filter", (String)null);
            if (filter != null) {
                String finalFilter = filter = ACFUtil.simplifyString(filter);
                colours = colours.filter(colour -> finalFilter.equals(ACFUtil.simplifyString(colour.getName())));
            }
            Stream finalColours = colours;
            return (TextColor)Sponge.getRegistry().getType(TextColor.class, ACFUtil.simplifyString(first)).orElseThrow(() -> {
                String valid = finalColours.map(colour -> "<c2>" + ACFUtil.simplifyString(colour.getName()) + "</c2>").collect(Collectors.joining("<c1>,</c1> "));
                return new InvalidCommandArgument((MessageKeyProvider)MessageKeys.PLEASE_SPECIFY_ONE_OF, "{valid}", valid);
            });
        });
        this.registerContext(TextStyle.Base.class, c -> {
            String first = c.popFirstArg();
            Stream<Object> styles = Sponge.getRegistry().getAllOf(TextStyle.Base.class).stream();
            String filter = c.getFlagValue("filter", (String)null);
            if (filter != null) {
                String finalFilter = filter = ACFUtil.simplifyString(filter);
                styles = styles.filter(style -> finalFilter.equals(ACFUtil.simplifyString(style.getName())));
            }
            Stream finalStyles = styles;
            return (TextStyle.Base)Sponge.getRegistry().getType(TextStyle.Base.class, ACFUtil.simplifyString(first)).orElseThrow(() -> {
                String valid = finalStyles.map(style -> "<c2>" + ACFUtil.simplifyString(style.getName()) + "</c2>").collect(Collectors.joining("<c1>,</c1> "));
                return new InvalidCommandArgument((MessageKeyProvider)MessageKeys.PLEASE_SPECIFY_ONE_OF, "{valid}", valid);
            });
        });
        this.registerIssuerAwareContext(CommandSource.class, SpongeCommandExecutionContext::getSource);
        this.registerIssuerAwareContext(Player.class, c -> {
            Player player;
            Player player2 = player = c.getSource() instanceof Player ? (Player)c.getSource() : null;
            if (player == null && !c.isOptional()) {
                throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.NOT_ALLOWED_ON_CONSOLE, false, new String[0]);
            }
            return player;
        });
        this.registerContext(co.aikar.commands.sponge.contexts.OnlinePlayer[].class, c -> {
            SpongeCommandIssuer issuer = (SpongeCommandIssuer)c.getIssuer();
            String search = c.popFirstArg();
            boolean allowMissing = c.hasFlag("allowmissing");
            HashSet<co.aikar.commands.sponge.contexts.OnlinePlayer> players = new HashSet<co.aikar.commands.sponge.contexts.OnlinePlayer>();
            Pattern split = ACFPatterns.COMMA;
            String splitter = c.getFlagValue("splitter", (String)null);
            if (splitter != null) {
                split = Pattern.compile(Pattern.quote(splitter));
            }
            for (String lookup : split.split(search)) {
                co.aikar.commands.sponge.contexts.OnlinePlayer player = this.getOnlinePlayer(issuer, lookup, allowMissing);
                if (player == null) continue;
                players.add(player);
            }
            if (players.isEmpty() && !c.hasFlag("allowempty")) {
                issuer.sendError(MinecraftMessageKeys.NO_PLAYER_FOUND_SERVER, "{search}", search);
                throw new InvalidCommandArgument(false);
            }
            return players.toArray(new co.aikar.commands.sponge.contexts.OnlinePlayer[players.size()]);
        });
        this.registerIssuerAwareContext(World.class, c -> {
            Optional<World> world;
            String firstArg = c.getFirstArg();
            Optional<World> optional = world = firstArg != null ? Sponge.getServer().getWorld(firstArg) : Optional.empty();
            if (world.isPresent()) {
                c.popFirstArg();
            }
            if (!world.isPresent() && c.getSource() instanceof Player) {
                world = Optional.of(((Player)c.getSource()).getWorld());
            }
            if (!world.isPresent()) {
                throw new InvalidCommandArgument((MessageKeyProvider)MinecraftMessageKeys.INVALID_WORLD, new String[0]);
            }
            return (World)world.get();
        });
    }

    @Nullable
    co.aikar.commands.sponge.contexts.OnlinePlayer getOnlinePlayer(SpongeCommandIssuer issuer, String lookup, boolean allowMissing) throws InvalidCommandArgument {
        Player player = ACFSpongeUtil.findPlayerSmart(issuer, lookup);
        if (player == null) {
            if (allowMissing) {
                return null;
            }
            throw new InvalidCommandArgument(false);
        }
        return new co.aikar.commands.sponge.contexts.OnlinePlayer(player);
    }
}

