/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.locales;

import co.aikar.locales.LanguageTable;
import co.aikar.locales.MessageKey;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LocaleManager<T> {
    private final Function<T, Locale> localeMapper;
    private final Map<Locale, LanguageTable> tables = new HashMap<Locale, LanguageTable>();
    private Locale defaultLocale;

    LocaleManager(@Nonnull Function<T, Locale> localeMapper, @Nonnull Locale defaultLocale) {
        this.localeMapper = localeMapper;
        this.defaultLocale = defaultLocale;
    }

    public static <T> LocaleManager<T> create(@Nonnull Function<T, Locale> localeMapper) {
        return new LocaleManager<T>(localeMapper, Locale.ENGLISH);
    }

    public static <T> LocaleManager<T> create(@Nonnull Function<T, Locale> localeMapper, @Nonnull Locale defaultLocale) {
        return new LocaleManager<T>(localeMapper, defaultLocale);
    }

    @Nonnull
    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    @Nonnull
    public Locale setDefaultLocale(@Nonnull Locale defaultLocale) {
        Locale previous = this.defaultLocale;
        this.defaultLocale = defaultLocale;
        return previous;
    }

    public boolean addMessageBundle(@Nonnull String bundleName, Locale ... locales) {
        return this.addMessageBundle(Thread.currentThread().getContextClassLoader(), bundleName, locales);
    }

    public boolean addMessageBundle(@Nonnull ClassLoader classLoader, @Nonnull String bundleName, Locale ... locales) {
        if (locales.length == 0) {
            locales = new Locale[]{this.defaultLocale};
        }
        boolean found = false;
        for (Locale locale : locales) {
            if (!this.getTable(locale).addMessageBundle(classLoader, bundleName)) continue;
            found = true;
        }
        return found;
    }

    public void addMessages(@Nonnull Locale locale, @Nonnull Map<MessageKey, String> messages) {
        this.getTable(locale).addMessages(messages);
    }

    @Nonnull
    public String addMessage(@Nonnull Locale locale, @Nonnull MessageKey key, @Nonnull String message) {
        return this.getTable(locale).addMessage(key, message);
    }

    @Nullable
    public String getMessage(@Nonnull T context, @Nonnull MessageKey key) {
        Locale locale = this.localeMapper.apply(context);
        String message = this.getTable(locale).getMessage(key);
        if (message == null && !locale.getCountry().isEmpty()) {
            message = this.getTable(new Locale(locale.getLanguage())).getMessage(key);
        }
        if (message == null && !Objects.equals(locale, this.defaultLocale)) {
            message = this.getTable(this.defaultLocale).getMessage(key);
        }
        return message;
    }

    @Nonnull
    public LanguageTable getTable(@Nonnull Locale locale) {
        return this.tables.computeIfAbsent(locale, LanguageTable::new);
    }

    public boolean addResourceBundle(@Nonnull ResourceBundle bundle, @Nonnull Locale locale) {
        return this.getTable(locale).addResourceBundle(bundle);
    }
}

