/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.CommandPermissionResolver;
import co.aikar.commands.JDACommandEvent;
import co.aikar.commands.JDACommandManager;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.dv8tion.jda.api.Permission;

public class JDACommandPermissionResolver
implements CommandPermissionResolver {
    private Map<String, Integer> discordPermissionOffsets = new HashMap<String, Integer>();

    public JDACommandPermissionResolver() {
        for (Permission permission : Permission.values()) {
            this.discordPermissionOffsets.put(permission.name().toLowerCase(Locale.ENGLISH).replaceAll("_", "-"), permission.getOffset());
        }
    }

    @Override
    public boolean hasPermission(JDACommandManager manager, JDACommandEvent event, String permission) {
        if (manager.getBotOwnerId() == event.getIssuer().getAuthor().getIdLong()) {
            return true;
        }
        if (event.getIssuer().isWebhookMessage()) {
            return false;
        }
        Integer permissionOffset = this.discordPermissionOffsets.get(permission);
        if (permissionOffset == null) {
            return false;
        }
        return event.getIssuer().getMember().hasPermission(new Permission[]{Permission.getFromOffset((int)permissionOffset)});
    }
}

