/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.ACFPatterns;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandCompletionContext;
import co.aikar.commands.CommandCompletions;
import co.aikar.commands.CommandConfig;
import co.aikar.commands.CommandConfigProvider;
import co.aikar.commands.CommandContexts;
import co.aikar.commands.CommandExecutionContext;
import co.aikar.commands.CommandIssuer;
import co.aikar.commands.CommandManager;
import co.aikar.commands.CommandParameter;
import co.aikar.commands.CommandPermissionResolver;
import co.aikar.commands.ConditionFailedException;
import co.aikar.commands.JDACommandCompletions;
import co.aikar.commands.JDACommandConfig;
import co.aikar.commands.JDACommandContexts;
import co.aikar.commands.JDACommandEvent;
import co.aikar.commands.JDACommandExecutionContext;
import co.aikar.commands.JDAConditionContext;
import co.aikar.commands.JDAListener;
import co.aikar.commands.JDALocales;
import co.aikar.commands.JDAMessageFormatter;
import co.aikar.commands.JDAOptions;
import co.aikar.commands.JDARootCommand;
import co.aikar.commands.Locales;
import co.aikar.commands.LogLevel;
import co.aikar.commands.MessageFormatter;
import co.aikar.commands.RegisteredCommand;
import co.aikar.commands.RootCommand;
import co.aikar.commands.apachecommonslang.ApacheCommonsExceptionUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.dv8tion.jda.api.AccountType;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.ApplicationInfo;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import org.jetbrains.annotations.NotNull;

public class JDACommandManager
extends CommandManager<MessageReceivedEvent, JDACommandEvent, String, MessageFormatter<String>, JDACommandExecutionContext, JDAConditionContext> {
    private final JDA jda;
    protected JDACommandCompletions completions;
    protected JDACommandContexts contexts;
    protected JDALocales locales;
    protected Map<String, JDARootCommand> commands = new HashMap<String, JDARootCommand>();
    private Logger logger;
    private CommandConfig defaultConfig;
    private CommandConfigProvider configProvider;
    private CommandPermissionResolver permissionResolver;
    private long botOwner = 0L;

    public JDACommandManager(JDA jda) {
        this(jda, null);
    }

    public JDACommandManager(JDA jda, JDAOptions options) {
        if (options == null) {
            options = new JDAOptions();
        }
        this.jda = jda;
        this.permissionResolver = options.permissionResolver;
        jda.addEventListener(new Object[]{new JDAListener(this)});
        this.defaultConfig = options.defaultConfig == null ? new JDACommandConfig() : options.defaultConfig;
        this.configProvider = options.configProvider;
        this.defaultFormatter = new JDAMessageFormatter();
        this.completions = new JDACommandCompletions(this);
        this.logger = Logger.getLogger(this.getClass().getSimpleName());
        this.getCommandConditions().addCondition("owneronly", context -> {
            if (((JDACommandEvent)context.getIssuer()).getEvent().getAuthor().getIdLong() != this.getBotOwnerId()) {
                throw new ConditionFailedException("Only the bot owner can use this command.");
            }
        });
        this.getCommandConditions().addCondition("guildonly", context -> {
            if (((JDACommandEvent)context.getIssuer()).getEvent().getChannelType() != ChannelType.TEXT) {
                throw new ConditionFailedException("This command must be used in guild chat.");
            }
        });
        this.getCommandConditions().addCondition("privateonly", context -> {
            if (((JDACommandEvent)context.getIssuer()).getEvent().getChannelType() != ChannelType.PRIVATE) {
                throw new ConditionFailedException("This command must be used in private chat.");
            }
        });
        this.getCommandConditions().addCondition("grouponly", context -> {
            if (((JDACommandEvent)context.getIssuer()).getEvent().getChannelType() != ChannelType.GROUP) {
                throw new ConditionFailedException("This command must be used in group chat.");
            }
        });
    }

    public static JDAOptions options() {
        return new JDAOptions();
    }

    void initializeBotOwner() {
        if (this.botOwner == 0L) {
            this.botOwner = this.jda.getAccountType() == AccountType.BOT ? ((ApplicationInfo)this.jda.retrieveApplicationInfo().complete()).getOwner().getIdLong() : this.jda.getSelfUser().getIdLong();
        }
    }

    public long getBotOwnerId() {
        this.initializeBotOwner();
        return this.botOwner;
    }

    public JDA getJDA() {
        return this.jda;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public CommandConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setDefaultConfig(@NotNull CommandConfig defaultConfig) {
        this.defaultConfig = defaultConfig;
    }

    public CommandConfigProvider getConfigProvider() {
        return this.configProvider;
    }

    public void setConfigProvider(CommandConfigProvider configProvider) {
        this.configProvider = configProvider;
    }

    public CommandPermissionResolver getPermissionResolver() {
        return this.permissionResolver;
    }

    public void setPermissionResolver(CommandPermissionResolver permissionResolver) {
        this.permissionResolver = permissionResolver;
    }

    @Override
    public CommandContexts<?> getCommandContexts() {
        if (this.contexts == null) {
            this.contexts = new JDACommandContexts(this);
        }
        return this.contexts;
    }

    @Override
    public CommandCompletions<?> getCommandCompletions() {
        return this.completions;
    }

    @Override
    public void registerCommand(BaseCommand command) {
        command.onRegister(this);
        for (Map.Entry<String, RootCommand> entry : command.registeredCommands.entrySet()) {
            String commandName = entry.getKey().toLowerCase(Locale.ENGLISH);
            JDARootCommand cmd = (JDARootCommand)entry.getValue();
            if (cmd.isRegistered) continue;
            cmd.isRegistered = true;
            this.commands.put(commandName, cmd);
        }
    }

    public void unregisterCommand(BaseCommand command) {
        for (Map.Entry<String, RootCommand> entry : command.registeredCommands.entrySet()) {
            String jdaCommandName = entry.getKey().toLowerCase(Locale.ENGLISH);
            JDARootCommand jdaCommand = (JDARootCommand)entry.getValue();
            jdaCommand.getSubCommands().values().removeAll(command.subCommands.values());
            if (!jdaCommand.isRegistered || !jdaCommand.getSubCommands().isEmpty()) continue;
            jdaCommand.isRegistered = false;
            this.commands.remove(jdaCommandName);
        }
    }

    @Override
    public boolean hasRegisteredCommands() {
        return !this.commands.isEmpty();
    }

    @Override
    public boolean isCommandIssuer(Class<?> type) {
        return JDACommandEvent.class.isAssignableFrom(type);
    }

    @Override
    public JDACommandEvent getCommandIssuer(Object issuer) {
        if (!(issuer instanceof MessageReceivedEvent)) {
            throw new IllegalArgumentException(issuer.getClass().getName() + " is not a Message Received Event.");
        }
        return new JDACommandEvent(this, (MessageReceivedEvent)issuer);
    }

    @Override
    public RootCommand createRootCommand(String cmd) {
        return new JDARootCommand(this, cmd);
    }

    @Override
    public Collection<RootCommand> getRegisteredRootCommands() {
        return Collections.unmodifiableCollection(this.commands.values());
    }

    @Override
    public Locales getLocales() {
        if (this.locales == null) {
            this.locales = new JDALocales(this);
            this.locales.loadLanguages();
        }
        return this.locales;
    }

    @Override
    public CommandExecutionContext createCommandContext(RegisteredCommand command, CommandParameter parameter, CommandIssuer sender, List<String> args, int i, Map<String, Object> passedArgs) {
        return new JDACommandExecutionContext(command, parameter, (JDACommandEvent)sender, args, i, passedArgs);
    }

    @Override
    public CommandCompletionContext createCompletionContext(RegisteredCommand command, CommandIssuer sender, String input, String config, String[] args) {
        return new CommandCompletionContext<CommandIssuer>(command, sender, input, config, args);
    }

    @Override
    public void log(LogLevel level, String message, Throwable throwable) {
        Level logLevel = level == LogLevel.INFO ? Level.INFO : Level.SEVERE;
        this.logger.log(logLevel, "[ACF] " + message);
        if (throwable != null) {
            for (String line : ACFPatterns.NEWLINE.split(ApacheCommonsExceptionUtil.getFullStackTrace(throwable))) {
                this.logger.log(logLevel, "[ACF] " + line);
            }
        }
    }

    void dispatchEvent(MessageReceivedEvent event) {
        Message message = event.getMessage();
        String msg = message.getContentRaw();
        CommandConfig config = this.getCommandConfig(event);
        String prefixFound = null;
        for (String prefix : config.getCommandPrefixes()) {
            if (!msg.startsWith(prefix)) continue;
            prefixFound = prefix;
            break;
        }
        if (prefixFound == null) {
            return;
        }
        String[] args = ACFPatterns.SPACE.split(msg.substring(prefixFound.length()), -1);
        if (args.length == 0) {
            return;
        }
        String cmd = args[0].toLowerCase(Locale.ENGLISH);
        JDARootCommand rootCommand = this.commands.get(cmd);
        if (rootCommand == null) {
            return;
        }
        args = args.length > 1 ? Arrays.copyOfRange(args, 1, args.length) : new String[]{};
        rootCommand.execute(this.getCommandIssuer(event), cmd, args);
    }

    private CommandConfig getCommandConfig(MessageReceivedEvent event) {
        CommandConfig provided;
        CommandConfig config = this.defaultConfig;
        if (this.configProvider != null && (provided = this.configProvider.provide(event)) != null) {
            config = provided;
        }
        return config;
    }

    @Override
    public String getCommandPrefix(CommandIssuer issuer) {
        MessageReceivedEvent event = ((JDACommandEvent)issuer).getEvent();
        CommandConfig commandConfig = this.getCommandConfig(event);
        List<String> prefixes = commandConfig.getCommandPrefixes();
        return prefixes.isEmpty() ? "" : prefixes.get(0);
    }
}

