/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.CommandContexts;
import co.aikar.commands.CommandExecutionContext;
import co.aikar.commands.InvalidCommandArgument;
import co.aikar.commands.JDACommandEvent;
import co.aikar.commands.JDACommandExecutionContext;
import co.aikar.commands.JDACommandManager;
import co.aikar.commands.annotation.Author;
import co.aikar.commands.annotation.CrossGuild;
import co.aikar.commands.annotation.SelfUser;
import java.util.List;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageChannel;
import net.dv8tion.jda.api.entities.Role;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;

public class JDACommandContexts
extends CommandContexts<JDACommandExecutionContext> {
    private final JDACommandManager manager;
    private final JDA jda;

    public JDACommandContexts(JDACommandManager manager) {
        super(manager);
        this.manager = manager;
        this.jda = this.manager.getJDA();
        this.registerIssuerOnlyContext(JDACommandEvent.class, CommandExecutionContext::getIssuer);
        this.registerIssuerOnlyContext(MessageReceivedEvent.class, c -> ((JDACommandEvent)c.getIssuer()).getIssuer());
        this.registerIssuerOnlyContext(Message.class, c -> ((JDACommandEvent)c.issuer).getIssuer().getMessage());
        this.registerIssuerOnlyContext(ChannelType.class, c -> ((JDACommandEvent)c.issuer).getIssuer().getChannelType());
        this.registerIssuerOnlyContext(JDA.class, c -> this.jda);
        this.registerIssuerOnlyContext(Guild.class, c -> {
            MessageReceivedEvent event = ((JDACommandEvent)c.getIssuer()).getIssuer();
            if (event.isFromType(ChannelType.PRIVATE) && !c.isOptional()) {
                throw new InvalidCommandArgument("This command can only be executed in a Guild.", false);
            }
            return event.getGuild();
        });
        this.registerIssuerAwareContext(MessageChannel.class, c -> {
            if (c.hasAnnotation(Author.class)) {
                return ((JDACommandEvent)c.issuer).getIssuer().getChannel();
            }
            boolean isCrossGuild = c.hasAnnotation(CrossGuild.class);
            String argument = c.popFirstArg();
            TextChannel channel = null;
            if (argument.startsWith("<#")) {
                String id = argument.substring(2, argument.length() - 1);
                channel = isCrossGuild ? this.jda.getTextChannelById(id) : ((JDACommandEvent)c.issuer).getIssuer().getGuild().getTextChannelById(id);
            } else {
                List channelList;
                List list = channelList = isCrossGuild ? this.jda.getTextChannelsByName(argument, true) : ((JDACommandEvent)c.issuer).getEvent().getGuild().getTextChannelsByName(argument, true);
                if (channelList.size() > 1) {
                    throw new InvalidCommandArgument("Too many channels were found with the given name. Try with the `#channelname` syntax.", false);
                }
                if (channelList.size() == 1) {
                    channel = (MessageChannel)channelList.get(0);
                }
            }
            if (channel == null) {
                throw new InvalidCommandArgument("Couldn't find a channel with that name or ID.");
            }
            return channel;
        });
        this.registerIssuerAwareContext(User.class, c -> {
            if (c.hasAnnotation(SelfUser.class)) {
                return this.jda.getSelfUser();
            }
            String arg = c.getFirstArg();
            if (c.isOptional() && (arg == null || arg.isEmpty())) {
                return null;
            }
            arg = c.popFirstArg();
            User user = null;
            if (arg.startsWith("<@!")) {
                user = this.jda.getUserById(arg.substring(3, arg.length() - 1));
            } else if (arg.startsWith("<@")) {
                user = this.jda.getUserById(arg.substring(2, arg.length() - 1));
            } else {
                List users = this.jda.getUsersByName(arg, true);
                if (users.size() > 1) {
                    throw new InvalidCommandArgument("Too many users were found with the given name. Try with the `@username#0000` syntax.", false);
                }
                if (!users.isEmpty()) {
                    user = (User)users.get(0);
                }
            }
            if (user == null) {
                throw new InvalidCommandArgument("Could not find a user with that name or ID.");
            }
            return user;
        });
        this.registerContext(Role.class, c -> {
            boolean isCrossGuild = c.hasAnnotation(CrossGuild.class);
            String arg = c.popFirstArg();
            Role role = null;
            if (arg.startsWith("<@&")) {
                String id = arg.substring(3, arg.length() - 1);
                role = isCrossGuild ? this.jda.getRoleById(id) : ((JDACommandEvent)c.issuer).getIssuer().getGuild().getRoleById(id);
            } else {
                List roles;
                List list = roles = isCrossGuild ? this.jda.getRolesByName(arg, true) : ((JDACommandEvent)c.issuer).getIssuer().getGuild().getRolesByName(arg, true);
                if (roles.size() > 1) {
                    throw new InvalidCommandArgument("Too many roles were found with the given name. Try with the `@role` syntax.", false);
                }
                if (!roles.isEmpty()) {
                    role = (Role)roles.get(0);
                }
            }
            if (role == null) {
                throw new InvalidCommandArgument("Could not find a role with that name or ID.");
            }
            return role;
        });
    }
}

