/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.locales;

import co.aikar.locales.MessageKey;
import co.aikar.locales.UTF8Control;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class LanguageTable {
    private final Locale locale;
    private final Map<MessageKey, String> messages = new HashMap<MessageKey, String>();

    LanguageTable(@Nonnull Locale locale) {
        this.locale = locale;
    }

    @Nonnull
    public String addMessage(@Nonnull MessageKey key, @Nonnull String message) {
        return Objects.requireNonNull(this.messages.put(key, message));
    }

    @Nullable
    public String getMessage(@Nonnull MessageKey key) {
        return this.messages.get(key);
    }

    public void addMessages(@Nonnull Map<MessageKey, String> messages) {
        this.messages.putAll(messages);
    }

    @Nonnull
    public Locale getLocale() {
        return this.locale;
    }

    public boolean addMessageBundle(@Nonnull String bundleName) {
        return this.addMessageBundle(Thread.currentThread().getContextClassLoader(), bundleName);
    }

    public boolean addMessageBundle(@Nonnull ClassLoader classLoader, @Nonnull String bundleName) {
        try {
            return this.addResourceBundle(ResourceBundle.getBundle(bundleName, this.locale, classLoader, new UTF8Control()));
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public boolean addResourceBundle(@Nonnull ResourceBundle bundle) {
        for (String key : bundle.keySet()) {
            this.addMessage(MessageKey.of(key), bundle.getString(key));
        }
        return !bundle.keySet().isEmpty();
    }
}

