/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.android;

import android.graphics.Bitmap;
import com.google.zxing.WriterException;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import net.glxn.qrgen.android.MatrixToImageWriter;
import net.glxn.qrgen.core.AbstractQRCode;
import net.glxn.qrgen.core.exception.QRGenerationException;
import net.glxn.qrgen.core.vcard.VCard;

public class QRCode
extends AbstractQRCode {
    protected final String text;

    protected QRCode(String text) {
        this.text = text;
        this.qrWriter = new QRCodeWriter();
    }

    public static QRCode from(String text) {
        return new QRCode(text);
    }

    public static AbstractQRCode from(VCard vcard) {
        return new QRCode(vcard.toString());
    }

    public Bitmap bitmap() {
        try {
            return MatrixToImageWriter.toBitmap(this.createMatrix(this.text));
        }
        catch (WriterException e) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", (Throwable)e);
        }
    }

    public File file() {
        File file;
        try {
            file = this.createTempFile();
            MatrixToImageWriter.writeToFile(this.createMatrix(this.text), this.imageType.toString(), file);
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", (Throwable)e);
        }
        return file;
    }

    public File file(String name) {
        File file;
        try {
            file = this.createTempFile(name);
            MatrixToImageWriter.writeToFile(this.createMatrix(this.text), this.imageType.toString(), file);
        }
        catch (Exception e) {
            throw new QRGenerationException("Failed to create QR image from text due to underlying exception", (Throwable)e);
        }
        return file;
    }

    protected void writeToStream(OutputStream stream) throws IOException, WriterException {
        MatrixToImageWriter.writeToStream(this.createMatrix(this.text), this.imageType.toString(), stream);
    }
}

