/*
 * Decompiled with CFR 0.152.
 */
package net.glxn.qrgen.android;

import android.graphics.Bitmap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.glxn.qrgen.android.BmpUtil;
import net.glxn.qrgen.core.image.ImageType;

public class BitmapIO {
    public static boolean write(Bitmap image, String type, OutputStream stream) throws IOException {
        if (type.equals(ImageType.PNG)) {
            return image.compress(Bitmap.CompressFormat.PNG, 80, stream);
        }
        if (type.equals(ImageType.JPG)) {
            return image.compress(Bitmap.CompressFormat.JPEG, 80, stream);
        }
        return BmpUtil.save(image, stream);
    }

    public static boolean write(Bitmap image, String type, File file) throws IOException {
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(file);
            boolean bl = BitmapIO.write(image, type, stream);
            return bl;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        finally {
            if (stream != null) {
                stream.flush();
                ((OutputStream)stream).close();
            }
        }
    }
}

