package net.gini.android.capture.camera;

import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.navigation.ActionOnlyNavDirections;
import androidx.navigation.NavDirections;
import java.io.Serializable;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import net.gini.android.capture.Document;
import net.gini.android.capture.DocumentImportEnabledFileTypes;
import net.gini.android.capture.R;
import net.gini.android.capture.error.ErrorType;

public class CameraFragmentDirections {
  private CameraFragmentDirections() {
  }

  @NonNull
  public static ToReviewFragment toReviewFragment(boolean GCSHOULDSCROLLTOLASTPAGE) {
    return new ToReviewFragment(GCSHOULDSCROLLTOLASTPAGE);
  }

  @NonNull
  public static ToAnalysisFragment toAnalysisFragment(@NonNull Document GCARGSDOCUMENT,
      @NonNull String GCARGSDOCUMENTANALYSISERRORMESSAGE) {
    return new ToAnalysisFragment(GCARGSDOCUMENT, GCARGSDOCUMENTANALYSISERRORMESSAGE);
  }

  @NonNull
  public static ToFileChooserFragment toFileChooserFragment(
      @NonNull DocumentImportEnabledFileTypes GCEXTRAINDOCUMENTIMPORTFILETYPES) {
    return new ToFileChooserFragment(GCEXTRAINDOCUMENTIMPORTFILETYPES);
  }

  @NonNull
  public static NavDirections toHelpFragment() {
    return new ActionOnlyNavDirections(R.id.to_help_fragment);
  }

  @NonNull
  public static ToErrorFragment toErrorFragment(@NonNull ErrorType GCARGSERROR,
      @NonNull Document ARGSDOCUMENT) {
    return new ToErrorFragment(GCARGSERROR, ARGSDOCUMENT);
  }

  @NonNull
  public static NavDirections toOnboardingFragment() {
    return new ActionOnlyNavDirections(R.id.to_onboarding_fragment);
  }

  @NonNull
  public static ToNoResultsFragment toNoResultsFragment(@NonNull Document GCARGSDOCUMENT) {
    return new ToNoResultsFragment(GCARGSDOCUMENT);
  }

  public static class ToReviewFragment implements NavDirections {
    private final HashMap arguments = new HashMap();

    @SuppressWarnings("unchecked")
    private ToReviewFragment(boolean GCSHOULDSCROLLTOLASTPAGE) {
      this.arguments.put("GC_SHOULD_SCROLL_TO_LAST_PAGE", GCSHOULDSCROLLTOLASTPAGE);
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToReviewFragment setGCSHOULDSCROLLTOLASTPAGE(boolean GCSHOULDSCROLLTOLASTPAGE) {
      this.arguments.put("GC_SHOULD_SCROLL_TO_LAST_PAGE", GCSHOULDSCROLLTOLASTPAGE);
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    @NonNull
    public Bundle getArguments() {
      Bundle __result = new Bundle();
      if (arguments.containsKey("GC_SHOULD_SCROLL_TO_LAST_PAGE")) {
        boolean GCSHOULDSCROLLTOLASTPAGE = (boolean) arguments.get("GC_SHOULD_SCROLL_TO_LAST_PAGE");
        __result.putBoolean("GC_SHOULD_SCROLL_TO_LAST_PAGE", GCSHOULDSCROLLTOLASTPAGE);
      }
      return __result;
    }

    @Override
    public int getActionId() {
      return R.id.to_review_fragment;
    }

    @SuppressWarnings("unchecked")
    public boolean getGCSHOULDSCROLLTOLASTPAGE() {
      return (boolean) arguments.get("GC_SHOULD_SCROLL_TO_LAST_PAGE");
    }

    @Override
    public boolean equals(Object object) {
      if (this == object) {
          return true;
      }
      if (object == null || getClass() != object.getClass()) {
          return false;
      }
      ToReviewFragment that = (ToReviewFragment) object;
      if (arguments.containsKey("GC_SHOULD_SCROLL_TO_LAST_PAGE") != that.arguments.containsKey("GC_SHOULD_SCROLL_TO_LAST_PAGE")) {
        return false;
      }
      if (getGCSHOULDSCROLLTOLASTPAGE() != that.getGCSHOULDSCROLLTOLASTPAGE()) {
        return false;
      }
      if (getActionId() != that.getActionId()) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      result = 31 * result + (getGCSHOULDSCROLLTOLASTPAGE() ? 1 : 0);
      result = 31 * result + getActionId();
      return result;
    }

    @Override
    public String toString() {
      return "ToReviewFragment(actionId=" + getActionId() + "){"
          + "GCSHOULDSCROLLTOLASTPAGE=" + getGCSHOULDSCROLLTOLASTPAGE()
          + "}";
    }
  }

  public static class ToAnalysisFragment implements NavDirections {
    private final HashMap arguments = new HashMap();

    @SuppressWarnings("unchecked")
    private ToAnalysisFragment(@NonNull Document GCARGSDOCUMENT,
        @NonNull String GCARGSDOCUMENTANALYSISERRORMESSAGE) {
      if (GCARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_DOCUMENT", GCARGSDOCUMENT);
      if (GCARGSDOCUMENTANALYSISERRORMESSAGE == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE", GCARGSDOCUMENTANALYSISERRORMESSAGE);
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToAnalysisFragment setGCARGSDOCUMENT(@NonNull Document GCARGSDOCUMENT) {
      if (GCARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_DOCUMENT", GCARGSDOCUMENT);
      return this;
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToAnalysisFragment setGCARGSDOCUMENTANALYSISERRORMESSAGE(
        @NonNull String GCARGSDOCUMENTANALYSISERRORMESSAGE) {
      if (GCARGSDOCUMENTANALYSISERRORMESSAGE == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE", GCARGSDOCUMENTANALYSISERRORMESSAGE);
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    @NonNull
    public Bundle getArguments() {
      Bundle __result = new Bundle();
      if (arguments.containsKey("GC_ARGS_DOCUMENT")) {
        Document GCARGSDOCUMENT = (Document) arguments.get("GC_ARGS_DOCUMENT");
        if (Parcelable.class.isAssignableFrom(Document.class) || GCARGSDOCUMENT == null) {
          __result.putParcelable("GC_ARGS_DOCUMENT", Parcelable.class.cast(GCARGSDOCUMENT));
        } else if (Serializable.class.isAssignableFrom(Document.class)) {
          __result.putSerializable("GC_ARGS_DOCUMENT", Serializable.class.cast(GCARGSDOCUMENT));
        } else {
          throw new UnsupportedOperationException(Document.class.getName() + " must implement Parcelable or Serializable or must be an Enum.");
        }
      }
      if (arguments.containsKey("GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE")) {
        String GCARGSDOCUMENTANALYSISERRORMESSAGE = (String) arguments.get("GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE");
        __result.putString("GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE", GCARGSDOCUMENTANALYSISERRORMESSAGE);
      }
      return __result;
    }

    @Override
    public int getActionId() {
      return R.id.to_analysis_fragment;
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public Document getGCARGSDOCUMENT() {
      return (Document) arguments.get("GC_ARGS_DOCUMENT");
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public String getGCARGSDOCUMENTANALYSISERRORMESSAGE() {
      return (String) arguments.get("GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE");
    }

    @Override
    public boolean equals(Object object) {
      if (this == object) {
          return true;
      }
      if (object == null || getClass() != object.getClass()) {
          return false;
      }
      ToAnalysisFragment that = (ToAnalysisFragment) object;
      if (arguments.containsKey("GC_ARGS_DOCUMENT") != that.arguments.containsKey("GC_ARGS_DOCUMENT")) {
        return false;
      }
      if (getGCARGSDOCUMENT() != null ? !getGCARGSDOCUMENT().equals(that.getGCARGSDOCUMENT()) : that.getGCARGSDOCUMENT() != null) {
        return false;
      }
      if (arguments.containsKey("GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE") != that.arguments.containsKey("GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE")) {
        return false;
      }
      if (getGCARGSDOCUMENTANALYSISERRORMESSAGE() != null ? !getGCARGSDOCUMENTANALYSISERRORMESSAGE().equals(that.getGCARGSDOCUMENTANALYSISERRORMESSAGE()) : that.getGCARGSDOCUMENTANALYSISERRORMESSAGE() != null) {
        return false;
      }
      if (getActionId() != that.getActionId()) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      result = 31 * result + (getGCARGSDOCUMENT() != null ? getGCARGSDOCUMENT().hashCode() : 0);
      result = 31 * result + (getGCARGSDOCUMENTANALYSISERRORMESSAGE() != null ? getGCARGSDOCUMENTANALYSISERRORMESSAGE().hashCode() : 0);
      result = 31 * result + getActionId();
      return result;
    }

    @Override
    public String toString() {
      return "ToAnalysisFragment(actionId=" + getActionId() + "){"
          + "GCARGSDOCUMENT=" + getGCARGSDOCUMENT()
          + ", GCARGSDOCUMENTANALYSISERRORMESSAGE=" + getGCARGSDOCUMENTANALYSISERRORMESSAGE()
          + "}";
    }
  }

  public static class ToFileChooserFragment implements NavDirections {
    private final HashMap arguments = new HashMap();

    @SuppressWarnings("unchecked")
    private ToFileChooserFragment(
        @NonNull DocumentImportEnabledFileTypes GCEXTRAINDOCUMENTIMPORTFILETYPES) {
      if (GCEXTRAINDOCUMENTIMPORTFILETYPES == null) {
        throw new IllegalArgumentException("Argument \"GC_EXTRA_IN_DOCUMENT_IMPORT_FILE_TYPES\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_EXTRA_IN_DOCUMENT_IMPORT_FILE_TYPES", GCEXTRAINDOCUMENTIMPORTFILETYPES);
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToFileChooserFragment setGCEXTRAINDOCUMENTIMPORTFILETYPES(
        @NonNull DocumentImportEnabledFileTypes GCEXTRAINDOCUMENTIMPORTFILETYPES) {
      if (GCEXTRAINDOCUMENTIMPORTFILETYPES == null) {
        throw new IllegalArgumentException("Argument \"GC_EXTRA_IN_DOCUMENT_IMPORT_FILE_TYPES\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_EXTRA_IN_DOCUMENT_IMPORT_FILE_TYPES", GCEXTRAINDOCUMENTIMPORTFILETYPES);
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    @NonNull
    public Bundle getArguments() {
      Bundle __result = new Bundle();
      if (arguments.containsKey("GC_EXTRA_IN_DOCUMENT_IMPORT_FILE_TYPES")) {
        DocumentImportEnabledFileTypes GCEXTRAINDOCUMENTIMPORTFILETYPES = (DocumentImportEnabledFileTypes) arguments.get("GC_EXTRA_IN_DOCUMENT_IMPORT_FILE_TYPES");
        if (Parcelable.class.isAssignableFrom(DocumentImportEnabledFileTypes.class) || GCEXTRAINDOCUMENTIMPORTFILETYPES == null) {
          __result.putParcelable("GC_EXTRA_IN_DOCUMENT_IMPORT_FILE_TYPES", Parcelable.class.cast(GCEXTRAINDOCUMENTIMPORTFILETYPES));
        } else if (Serializable.class.isAssignableFrom(DocumentImportEnabledFileTypes.class)) {
          __result.putSerializable("GC_EXTRA_IN_DOCUMENT_IMPORT_FILE_TYPES", Serializable.class.cast(GCEXTRAINDOCUMENTIMPORTFILETYPES));
        } else {
          throw new UnsupportedOperationException(DocumentImportEnabledFileTypes.class.getName() + " must implement Parcelable or Serializable or must be an Enum.");
        }
      }
      return __result;
    }

    @Override
    public int getActionId() {
      return R.id.to_file_chooser_fragment;
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public DocumentImportEnabledFileTypes getGCEXTRAINDOCUMENTIMPORTFILETYPES() {
      return (DocumentImportEnabledFileTypes) arguments.get("GC_EXTRA_IN_DOCUMENT_IMPORT_FILE_TYPES");
    }

    @Override
    public boolean equals(Object object) {
      if (this == object) {
          return true;
      }
      if (object == null || getClass() != object.getClass()) {
          return false;
      }
      ToFileChooserFragment that = (ToFileChooserFragment) object;
      if (arguments.containsKey("GC_EXTRA_IN_DOCUMENT_IMPORT_FILE_TYPES") != that.arguments.containsKey("GC_EXTRA_IN_DOCUMENT_IMPORT_FILE_TYPES")) {
        return false;
      }
      if (getGCEXTRAINDOCUMENTIMPORTFILETYPES() != null ? !getGCEXTRAINDOCUMENTIMPORTFILETYPES().equals(that.getGCEXTRAINDOCUMENTIMPORTFILETYPES()) : that.getGCEXTRAINDOCUMENTIMPORTFILETYPES() != null) {
        return false;
      }
      if (getActionId() != that.getActionId()) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      result = 31 * result + (getGCEXTRAINDOCUMENTIMPORTFILETYPES() != null ? getGCEXTRAINDOCUMENTIMPORTFILETYPES().hashCode() : 0);
      result = 31 * result + getActionId();
      return result;
    }

    @Override
    public String toString() {
      return "ToFileChooserFragment(actionId=" + getActionId() + "){"
          + "GCEXTRAINDOCUMENTIMPORTFILETYPES=" + getGCEXTRAINDOCUMENTIMPORTFILETYPES()
          + "}";
    }
  }

  public static class ToErrorFragment implements NavDirections {
    private final HashMap arguments = new HashMap();

    @SuppressWarnings("unchecked")
    private ToErrorFragment(@NonNull ErrorType GCARGSERROR, @NonNull Document ARGSDOCUMENT) {
      if (GCARGSERROR == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_ERROR\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_ERROR", GCARGSERROR);
      if (ARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("ARGS_DOCUMENT", ARGSDOCUMENT);
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToErrorFragment setGCARGSERROR(@NonNull ErrorType GCARGSERROR) {
      if (GCARGSERROR == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_ERROR\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_ERROR", GCARGSERROR);
      return this;
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToErrorFragment setARGSDOCUMENT(@NonNull Document ARGSDOCUMENT) {
      if (ARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("ARGS_DOCUMENT", ARGSDOCUMENT);
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    @NonNull
    public Bundle getArguments() {
      Bundle __result = new Bundle();
      if (arguments.containsKey("GC_ARGS_ERROR")) {
        ErrorType GCARGSERROR = (ErrorType) arguments.get("GC_ARGS_ERROR");
        if (Parcelable.class.isAssignableFrom(ErrorType.class) || GCARGSERROR == null) {
          __result.putParcelable("GC_ARGS_ERROR", Parcelable.class.cast(GCARGSERROR));
        } else if (Serializable.class.isAssignableFrom(ErrorType.class)) {
          __result.putSerializable("GC_ARGS_ERROR", Serializable.class.cast(GCARGSERROR));
        } else {
          throw new UnsupportedOperationException(ErrorType.class.getName() + " must implement Parcelable or Serializable or must be an Enum.");
        }
      }
      if (arguments.containsKey("ARGS_DOCUMENT")) {
        Document ARGSDOCUMENT = (Document) arguments.get("ARGS_DOCUMENT");
        if (Parcelable.class.isAssignableFrom(Document.class) || ARGSDOCUMENT == null) {
          __result.putParcelable("ARGS_DOCUMENT", Parcelable.class.cast(ARGSDOCUMENT));
        } else if (Serializable.class.isAssignableFrom(Document.class)) {
          __result.putSerializable("ARGS_DOCUMENT", Serializable.class.cast(ARGSDOCUMENT));
        } else {
          throw new UnsupportedOperationException(Document.class.getName() + " must implement Parcelable or Serializable or must be an Enum.");
        }
      }
      return __result;
    }

    @Override
    public int getActionId() {
      return R.id.to_error_fragment;
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public ErrorType getGCARGSERROR() {
      return (ErrorType) arguments.get("GC_ARGS_ERROR");
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public Document getARGSDOCUMENT() {
      return (Document) arguments.get("ARGS_DOCUMENT");
    }

    @Override
    public boolean equals(Object object) {
      if (this == object) {
          return true;
      }
      if (object == null || getClass() != object.getClass()) {
          return false;
      }
      ToErrorFragment that = (ToErrorFragment) object;
      if (arguments.containsKey("GC_ARGS_ERROR") != that.arguments.containsKey("GC_ARGS_ERROR")) {
        return false;
      }
      if (getGCARGSERROR() != null ? !getGCARGSERROR().equals(that.getGCARGSERROR()) : that.getGCARGSERROR() != null) {
        return false;
      }
      if (arguments.containsKey("ARGS_DOCUMENT") != that.arguments.containsKey("ARGS_DOCUMENT")) {
        return false;
      }
      if (getARGSDOCUMENT() != null ? !getARGSDOCUMENT().equals(that.getARGSDOCUMENT()) : that.getARGSDOCUMENT() != null) {
        return false;
      }
      if (getActionId() != that.getActionId()) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      result = 31 * result + (getGCARGSERROR() != null ? getGCARGSERROR().hashCode() : 0);
      result = 31 * result + (getARGSDOCUMENT() != null ? getARGSDOCUMENT().hashCode() : 0);
      result = 31 * result + getActionId();
      return result;
    }

    @Override
    public String toString() {
      return "ToErrorFragment(actionId=" + getActionId() + "){"
          + "GCARGSERROR=" + getGCARGSERROR()
          + ", ARGSDOCUMENT=" + getARGSDOCUMENT()
          + "}";
    }
  }

  public static class ToNoResultsFragment implements NavDirections {
    private final HashMap arguments = new HashMap();

    @SuppressWarnings("unchecked")
    private ToNoResultsFragment(@NonNull Document GCARGSDOCUMENT) {
      if (GCARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_DOCUMENT", GCARGSDOCUMENT);
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToNoResultsFragment setGCARGSDOCUMENT(@NonNull Document GCARGSDOCUMENT) {
      if (GCARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_DOCUMENT", GCARGSDOCUMENT);
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    @NonNull
    public Bundle getArguments() {
      Bundle __result = new Bundle();
      if (arguments.containsKey("GC_ARGS_DOCUMENT")) {
        Document GCARGSDOCUMENT = (Document) arguments.get("GC_ARGS_DOCUMENT");
        if (Parcelable.class.isAssignableFrom(Document.class) || GCARGSDOCUMENT == null) {
          __result.putParcelable("GC_ARGS_DOCUMENT", Parcelable.class.cast(GCARGSDOCUMENT));
        } else if (Serializable.class.isAssignableFrom(Document.class)) {
          __result.putSerializable("GC_ARGS_DOCUMENT", Serializable.class.cast(GCARGSDOCUMENT));
        } else {
          throw new UnsupportedOperationException(Document.class.getName() + " must implement Parcelable or Serializable or must be an Enum.");
        }
      }
      return __result;
    }

    @Override
    public int getActionId() {
      return R.id.to_no_results_fragment;
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public Document getGCARGSDOCUMENT() {
      return (Document) arguments.get("GC_ARGS_DOCUMENT");
    }

    @Override
    public boolean equals(Object object) {
      if (this == object) {
          return true;
      }
      if (object == null || getClass() != object.getClass()) {
          return false;
      }
      ToNoResultsFragment that = (ToNoResultsFragment) object;
      if (arguments.containsKey("GC_ARGS_DOCUMENT") != that.arguments.containsKey("GC_ARGS_DOCUMENT")) {
        return false;
      }
      if (getGCARGSDOCUMENT() != null ? !getGCARGSDOCUMENT().equals(that.getGCARGSDOCUMENT()) : that.getGCARGSDOCUMENT() != null) {
        return false;
      }
      if (getActionId() != that.getActionId()) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      result = 31 * result + (getGCARGSDOCUMENT() != null ? getGCARGSDOCUMENT().hashCode() : 0);
      result = 31 * result + getActionId();
      return result;
    }

    @Override
    public String toString() {
      return "ToNoResultsFragment(actionId=" + getActionId() + "){"
          + "GCARGSDOCUMENT=" + getGCARGSDOCUMENT()
          + "}";
    }
  }
}
