package net.gini.android.capture.review.multipage;

import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.navigation.ActionOnlyNavDirections;
import androidx.navigation.NavDirections;
import java.io.Serializable;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import net.gini.android.capture.Document;
import net.gini.android.capture.R;
import net.gini.android.capture.error.ErrorType;

public class MultiPageReviewFragmentDirections {
  private MultiPageReviewFragmentDirections() {
  }

  @NonNull
  public static ToCameraFragmentForAddingPages toCameraFragmentForAddingPages() {
    return new ToCameraFragmentForAddingPages();
  }

  @NonNull
  public static NavDirections toCameraFragmentForFirstPage() {
    return new ActionOnlyNavDirections(R.id.to_camera_fragment_for_first_page);
  }

  @NonNull
  public static ToAnalysisFragment toAnalysisFragment(@NonNull Document GCARGSDOCUMENT,
      @NonNull String GCARGSDOCUMENTANALYSISERRORMESSAGE) {
    return new ToAnalysisFragment(GCARGSDOCUMENT, GCARGSDOCUMENTANALYSISERRORMESSAGE);
  }

  @NonNull
  public static ToErrorFragment toErrorFragment(@NonNull ErrorType GCARGSERROR,
      @NonNull Document ARGSDOCUMENT) {
    return new ToErrorFragment(GCARGSERROR, ARGSDOCUMENT);
  }

  @NonNull
  public static ToZoomInPreviewFragment toZoomInPreviewFragment(@NonNull Document GCARGSDOCUMENT) {
    return new ToZoomInPreviewFragment(GCARGSDOCUMENT);
  }

  public static class ToCameraFragmentForAddingPages implements NavDirections {
    private final HashMap arguments = new HashMap();

    private ToCameraFragmentForAddingPages() {
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToCameraFragmentForAddingPages setGCARGSADDPAGES(boolean GCARGSADDPAGES) {
      this.arguments.put("GC_ARGS_ADD_PAGES", GCARGSADDPAGES);
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    @NonNull
    public Bundle getArguments() {
      Bundle __result = new Bundle();
      if (arguments.containsKey("GC_ARGS_ADD_PAGES")) {
        boolean GCARGSADDPAGES = (boolean) arguments.get("GC_ARGS_ADD_PAGES");
        __result.putBoolean("GC_ARGS_ADD_PAGES", GCARGSADDPAGES);
      } else {
        __result.putBoolean("GC_ARGS_ADD_PAGES", true);
      }
      return __result;
    }

    @Override
    public int getActionId() {
      return R.id.to_camera_fragment_for_adding_pages;
    }

    @SuppressWarnings("unchecked")
    public boolean getGCARGSADDPAGES() {
      return (boolean) arguments.get("GC_ARGS_ADD_PAGES");
    }

    @Override
    public boolean equals(Object object) {
      if (this == object) {
          return true;
      }
      if (object == null || getClass() != object.getClass()) {
          return false;
      }
      ToCameraFragmentForAddingPages that = (ToCameraFragmentForAddingPages) object;
      if (arguments.containsKey("GC_ARGS_ADD_PAGES") != that.arguments.containsKey("GC_ARGS_ADD_PAGES")) {
        return false;
      }
      if (getGCARGSADDPAGES() != that.getGCARGSADDPAGES()) {
        return false;
      }
      if (getActionId() != that.getActionId()) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      result = 31 * result + (getGCARGSADDPAGES() ? 1 : 0);
      result = 31 * result + getActionId();
      return result;
    }

    @Override
    public String toString() {
      return "ToCameraFragmentForAddingPages(actionId=" + getActionId() + "){"
          + "GCARGSADDPAGES=" + getGCARGSADDPAGES()
          + "}";
    }
  }

  public static class ToAnalysisFragment implements NavDirections {
    private final HashMap arguments = new HashMap();

    @SuppressWarnings("unchecked")
    private ToAnalysisFragment(@NonNull Document GCARGSDOCUMENT,
        @NonNull String GCARGSDOCUMENTANALYSISERRORMESSAGE) {
      if (GCARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_DOCUMENT", GCARGSDOCUMENT);
      if (GCARGSDOCUMENTANALYSISERRORMESSAGE == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE", GCARGSDOCUMENTANALYSISERRORMESSAGE);
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToAnalysisFragment setGCARGSDOCUMENT(@NonNull Document GCARGSDOCUMENT) {
      if (GCARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_DOCUMENT", GCARGSDOCUMENT);
      return this;
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToAnalysisFragment setGCARGSDOCUMENTANALYSISERRORMESSAGE(
        @NonNull String GCARGSDOCUMENTANALYSISERRORMESSAGE) {
      if (GCARGSDOCUMENTANALYSISERRORMESSAGE == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE", GCARGSDOCUMENTANALYSISERRORMESSAGE);
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    @NonNull
    public Bundle getArguments() {
      Bundle __result = new Bundle();
      if (arguments.containsKey("GC_ARGS_DOCUMENT")) {
        Document GCARGSDOCUMENT = (Document) arguments.get("GC_ARGS_DOCUMENT");
        if (Parcelable.class.isAssignableFrom(Document.class) || GCARGSDOCUMENT == null) {
          __result.putParcelable("GC_ARGS_DOCUMENT", Parcelable.class.cast(GCARGSDOCUMENT));
        } else if (Serializable.class.isAssignableFrom(Document.class)) {
          __result.putSerializable("GC_ARGS_DOCUMENT", Serializable.class.cast(GCARGSDOCUMENT));
        } else {
          throw new UnsupportedOperationException(Document.class.getName() + " must implement Parcelable or Serializable or must be an Enum.");
        }
      }
      if (arguments.containsKey("GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE")) {
        String GCARGSDOCUMENTANALYSISERRORMESSAGE = (String) arguments.get("GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE");
        __result.putString("GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE", GCARGSDOCUMENTANALYSISERRORMESSAGE);
      }
      return __result;
    }

    @Override
    public int getActionId() {
      return R.id.to_analysis_fragment;
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public Document getGCARGSDOCUMENT() {
      return (Document) arguments.get("GC_ARGS_DOCUMENT");
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public String getGCARGSDOCUMENTANALYSISERRORMESSAGE() {
      return (String) arguments.get("GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE");
    }

    @Override
    public boolean equals(Object object) {
      if (this == object) {
          return true;
      }
      if (object == null || getClass() != object.getClass()) {
          return false;
      }
      ToAnalysisFragment that = (ToAnalysisFragment) object;
      if (arguments.containsKey("GC_ARGS_DOCUMENT") != that.arguments.containsKey("GC_ARGS_DOCUMENT")) {
        return false;
      }
      if (getGCARGSDOCUMENT() != null ? !getGCARGSDOCUMENT().equals(that.getGCARGSDOCUMENT()) : that.getGCARGSDOCUMENT() != null) {
        return false;
      }
      if (arguments.containsKey("GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE") != that.arguments.containsKey("GC_ARGS_DOCUMENT_ANALYSIS_ERROR_MESSAGE")) {
        return false;
      }
      if (getGCARGSDOCUMENTANALYSISERRORMESSAGE() != null ? !getGCARGSDOCUMENTANALYSISERRORMESSAGE().equals(that.getGCARGSDOCUMENTANALYSISERRORMESSAGE()) : that.getGCARGSDOCUMENTANALYSISERRORMESSAGE() != null) {
        return false;
      }
      if (getActionId() != that.getActionId()) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      result = 31 * result + (getGCARGSDOCUMENT() != null ? getGCARGSDOCUMENT().hashCode() : 0);
      result = 31 * result + (getGCARGSDOCUMENTANALYSISERRORMESSAGE() != null ? getGCARGSDOCUMENTANALYSISERRORMESSAGE().hashCode() : 0);
      result = 31 * result + getActionId();
      return result;
    }

    @Override
    public String toString() {
      return "ToAnalysisFragment(actionId=" + getActionId() + "){"
          + "GCARGSDOCUMENT=" + getGCARGSDOCUMENT()
          + ", GCARGSDOCUMENTANALYSISERRORMESSAGE=" + getGCARGSDOCUMENTANALYSISERRORMESSAGE()
          + "}";
    }
  }

  public static class ToErrorFragment implements NavDirections {
    private final HashMap arguments = new HashMap();

    @SuppressWarnings("unchecked")
    private ToErrorFragment(@NonNull ErrorType GCARGSERROR, @NonNull Document ARGSDOCUMENT) {
      if (GCARGSERROR == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_ERROR\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_ERROR", GCARGSERROR);
      if (ARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("ARGS_DOCUMENT", ARGSDOCUMENT);
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToErrorFragment setGCARGSERROR(@NonNull ErrorType GCARGSERROR) {
      if (GCARGSERROR == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_ERROR\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_ERROR", GCARGSERROR);
      return this;
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToErrorFragment setARGSDOCUMENT(@NonNull Document ARGSDOCUMENT) {
      if (ARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("ARGS_DOCUMENT", ARGSDOCUMENT);
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    @NonNull
    public Bundle getArguments() {
      Bundle __result = new Bundle();
      if (arguments.containsKey("GC_ARGS_ERROR")) {
        ErrorType GCARGSERROR = (ErrorType) arguments.get("GC_ARGS_ERROR");
        if (Parcelable.class.isAssignableFrom(ErrorType.class) || GCARGSERROR == null) {
          __result.putParcelable("GC_ARGS_ERROR", Parcelable.class.cast(GCARGSERROR));
        } else if (Serializable.class.isAssignableFrom(ErrorType.class)) {
          __result.putSerializable("GC_ARGS_ERROR", Serializable.class.cast(GCARGSERROR));
        } else {
          throw new UnsupportedOperationException(ErrorType.class.getName() + " must implement Parcelable or Serializable or must be an Enum.");
        }
      }
      if (arguments.containsKey("ARGS_DOCUMENT")) {
        Document ARGSDOCUMENT = (Document) arguments.get("ARGS_DOCUMENT");
        if (Parcelable.class.isAssignableFrom(Document.class) || ARGSDOCUMENT == null) {
          __result.putParcelable("ARGS_DOCUMENT", Parcelable.class.cast(ARGSDOCUMENT));
        } else if (Serializable.class.isAssignableFrom(Document.class)) {
          __result.putSerializable("ARGS_DOCUMENT", Serializable.class.cast(ARGSDOCUMENT));
        } else {
          throw new UnsupportedOperationException(Document.class.getName() + " must implement Parcelable or Serializable or must be an Enum.");
        }
      }
      return __result;
    }

    @Override
    public int getActionId() {
      return R.id.to_error_fragment;
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public ErrorType getGCARGSERROR() {
      return (ErrorType) arguments.get("GC_ARGS_ERROR");
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public Document getARGSDOCUMENT() {
      return (Document) arguments.get("ARGS_DOCUMENT");
    }

    @Override
    public boolean equals(Object object) {
      if (this == object) {
          return true;
      }
      if (object == null || getClass() != object.getClass()) {
          return false;
      }
      ToErrorFragment that = (ToErrorFragment) object;
      if (arguments.containsKey("GC_ARGS_ERROR") != that.arguments.containsKey("GC_ARGS_ERROR")) {
        return false;
      }
      if (getGCARGSERROR() != null ? !getGCARGSERROR().equals(that.getGCARGSERROR()) : that.getGCARGSERROR() != null) {
        return false;
      }
      if (arguments.containsKey("ARGS_DOCUMENT") != that.arguments.containsKey("ARGS_DOCUMENT")) {
        return false;
      }
      if (getARGSDOCUMENT() != null ? !getARGSDOCUMENT().equals(that.getARGSDOCUMENT()) : that.getARGSDOCUMENT() != null) {
        return false;
      }
      if (getActionId() != that.getActionId()) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      result = 31 * result + (getGCARGSERROR() != null ? getGCARGSERROR().hashCode() : 0);
      result = 31 * result + (getARGSDOCUMENT() != null ? getARGSDOCUMENT().hashCode() : 0);
      result = 31 * result + getActionId();
      return result;
    }

    @Override
    public String toString() {
      return "ToErrorFragment(actionId=" + getActionId() + "){"
          + "GCARGSERROR=" + getGCARGSERROR()
          + ", ARGSDOCUMENT=" + getARGSDOCUMENT()
          + "}";
    }
  }

  public static class ToZoomInPreviewFragment implements NavDirections {
    private final HashMap arguments = new HashMap();

    @SuppressWarnings("unchecked")
    private ToZoomInPreviewFragment(@NonNull Document GCARGSDOCUMENT) {
      if (GCARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_DOCUMENT", GCARGSDOCUMENT);
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToZoomInPreviewFragment setGCARGSDOCUMENT(@NonNull Document GCARGSDOCUMENT) {
      if (GCARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_DOCUMENT", GCARGSDOCUMENT);
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    @NonNull
    public Bundle getArguments() {
      Bundle __result = new Bundle();
      if (arguments.containsKey("GC_ARGS_DOCUMENT")) {
        Document GCARGSDOCUMENT = (Document) arguments.get("GC_ARGS_DOCUMENT");
        if (Parcelable.class.isAssignableFrom(Document.class) || GCARGSDOCUMENT == null) {
          __result.putParcelable("GC_ARGS_DOCUMENT", Parcelable.class.cast(GCARGSDOCUMENT));
        } else if (Serializable.class.isAssignableFrom(Document.class)) {
          __result.putSerializable("GC_ARGS_DOCUMENT", Serializable.class.cast(GCARGSDOCUMENT));
        } else {
          throw new UnsupportedOperationException(Document.class.getName() + " must implement Parcelable or Serializable or must be an Enum.");
        }
      }
      return __result;
    }

    @Override
    public int getActionId() {
      return R.id.to_zoom_in_preview_fragment;
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public Document getGCARGSDOCUMENT() {
      return (Document) arguments.get("GC_ARGS_DOCUMENT");
    }

    @Override
    public boolean equals(Object object) {
      if (this == object) {
          return true;
      }
      if (object == null || getClass() != object.getClass()) {
          return false;
      }
      ToZoomInPreviewFragment that = (ToZoomInPreviewFragment) object;
      if (arguments.containsKey("GC_ARGS_DOCUMENT") != that.arguments.containsKey("GC_ARGS_DOCUMENT")) {
        return false;
      }
      if (getGCARGSDOCUMENT() != null ? !getGCARGSDOCUMENT().equals(that.getGCARGSDOCUMENT()) : that.getGCARGSDOCUMENT() != null) {
        return false;
      }
      if (getActionId() != that.getActionId()) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      result = 31 * result + (getGCARGSDOCUMENT() != null ? getGCARGSDOCUMENT().hashCode() : 0);
      result = 31 * result + getActionId();
      return result;
    }

    @Override
    public String toString() {
      return "ToZoomInPreviewFragment(actionId=" + getActionId() + "){"
          + "GCARGSDOCUMENT=" + getGCARGSDOCUMENT()
          + "}";
    }
  }
}
