package net.gini.android.capture.analysis;

import android.os.Bundle;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.navigation.NavDirections;
import java.io.Serializable;
import java.lang.IllegalArgumentException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import net.gini.android.capture.Document;
import net.gini.android.capture.R;
import net.gini.android.capture.error.ErrorType;

public class AnalysisFragmentDirections {
  private AnalysisFragmentDirections() {
  }

  @NonNull
  public static ToErrorFragmentWithErrorType toErrorFragmentWithErrorType(
      @NonNull ErrorType GCARGSERROR, @NonNull Document ARGSDOCUMENT) {
    return new ToErrorFragmentWithErrorType(GCARGSERROR, ARGSDOCUMENT);
  }

  @NonNull
  public static ToErrorFragmentWithErrorMessage toErrorFragmentWithErrorMessage(
      @NonNull String ARGSCUSTOMERROR, @NonNull Document ARGSDOCUMENT) {
    return new ToErrorFragmentWithErrorMessage(ARGSCUSTOMERROR, ARGSDOCUMENT);
  }

  @NonNull
  public static ToNoResultsFragment toNoResultsFragment(@NonNull Document GCARGSDOCUMENT) {
    return new ToNoResultsFragment(GCARGSDOCUMENT);
  }

  public static class ToErrorFragmentWithErrorType implements NavDirections {
    private final HashMap arguments = new HashMap();

    @SuppressWarnings("unchecked")
    private ToErrorFragmentWithErrorType(@NonNull ErrorType GCARGSERROR,
        @NonNull Document ARGSDOCUMENT) {
      if (GCARGSERROR == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_ERROR\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_ERROR", GCARGSERROR);
      if (ARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("ARGS_DOCUMENT", ARGSDOCUMENT);
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToErrorFragmentWithErrorType setGCARGSERROR(@NonNull ErrorType GCARGSERROR) {
      if (GCARGSERROR == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_ERROR\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_ERROR", GCARGSERROR);
      return this;
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToErrorFragmentWithErrorType setARGSDOCUMENT(@NonNull Document ARGSDOCUMENT) {
      if (ARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("ARGS_DOCUMENT", ARGSDOCUMENT);
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    @NonNull
    public Bundle getArguments() {
      Bundle __result = new Bundle();
      if (arguments.containsKey("GC_ARGS_ERROR")) {
        ErrorType GCARGSERROR = (ErrorType) arguments.get("GC_ARGS_ERROR");
        if (Parcelable.class.isAssignableFrom(ErrorType.class) || GCARGSERROR == null) {
          __result.putParcelable("GC_ARGS_ERROR", Parcelable.class.cast(GCARGSERROR));
        } else if (Serializable.class.isAssignableFrom(ErrorType.class)) {
          __result.putSerializable("GC_ARGS_ERROR", Serializable.class.cast(GCARGSERROR));
        } else {
          throw new UnsupportedOperationException(ErrorType.class.getName() + " must implement Parcelable or Serializable or must be an Enum.");
        }
      }
      if (arguments.containsKey("ARGS_DOCUMENT")) {
        Document ARGSDOCUMENT = (Document) arguments.get("ARGS_DOCUMENT");
        if (Parcelable.class.isAssignableFrom(Document.class) || ARGSDOCUMENT == null) {
          __result.putParcelable("ARGS_DOCUMENT", Parcelable.class.cast(ARGSDOCUMENT));
        } else if (Serializable.class.isAssignableFrom(Document.class)) {
          __result.putSerializable("ARGS_DOCUMENT", Serializable.class.cast(ARGSDOCUMENT));
        } else {
          throw new UnsupportedOperationException(Document.class.getName() + " must implement Parcelable or Serializable or must be an Enum.");
        }
      }
      return __result;
    }

    @Override
    public int getActionId() {
      return R.id.to_error_fragment_with_error_type;
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public ErrorType getGCARGSERROR() {
      return (ErrorType) arguments.get("GC_ARGS_ERROR");
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public Document getARGSDOCUMENT() {
      return (Document) arguments.get("ARGS_DOCUMENT");
    }

    @Override
    public boolean equals(Object object) {
      if (this == object) {
          return true;
      }
      if (object == null || getClass() != object.getClass()) {
          return false;
      }
      ToErrorFragmentWithErrorType that = (ToErrorFragmentWithErrorType) object;
      if (arguments.containsKey("GC_ARGS_ERROR") != that.arguments.containsKey("GC_ARGS_ERROR")) {
        return false;
      }
      if (getGCARGSERROR() != null ? !getGCARGSERROR().equals(that.getGCARGSERROR()) : that.getGCARGSERROR() != null) {
        return false;
      }
      if (arguments.containsKey("ARGS_DOCUMENT") != that.arguments.containsKey("ARGS_DOCUMENT")) {
        return false;
      }
      if (getARGSDOCUMENT() != null ? !getARGSDOCUMENT().equals(that.getARGSDOCUMENT()) : that.getARGSDOCUMENT() != null) {
        return false;
      }
      if (getActionId() != that.getActionId()) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      result = 31 * result + (getGCARGSERROR() != null ? getGCARGSERROR().hashCode() : 0);
      result = 31 * result + (getARGSDOCUMENT() != null ? getARGSDOCUMENT().hashCode() : 0);
      result = 31 * result + getActionId();
      return result;
    }

    @Override
    public String toString() {
      return "ToErrorFragmentWithErrorType(actionId=" + getActionId() + "){"
          + "GCARGSERROR=" + getGCARGSERROR()
          + ", ARGSDOCUMENT=" + getARGSDOCUMENT()
          + "}";
    }
  }

  public static class ToErrorFragmentWithErrorMessage implements NavDirections {
    private final HashMap arguments = new HashMap();

    @SuppressWarnings("unchecked")
    private ToErrorFragmentWithErrorMessage(@NonNull String ARGSCUSTOMERROR,
        @NonNull Document ARGSDOCUMENT) {
      if (ARGSCUSTOMERROR == null) {
        throw new IllegalArgumentException("Argument \"ARGS_CUSTOM_ERROR\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("ARGS_CUSTOM_ERROR", ARGSCUSTOMERROR);
      if (ARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("ARGS_DOCUMENT", ARGSDOCUMENT);
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToErrorFragmentWithErrorMessage setARGSCUSTOMERROR(@NonNull String ARGSCUSTOMERROR) {
      if (ARGSCUSTOMERROR == null) {
        throw new IllegalArgumentException("Argument \"ARGS_CUSTOM_ERROR\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("ARGS_CUSTOM_ERROR", ARGSCUSTOMERROR);
      return this;
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToErrorFragmentWithErrorMessage setARGSDOCUMENT(@NonNull Document ARGSDOCUMENT) {
      if (ARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("ARGS_DOCUMENT", ARGSDOCUMENT);
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    @NonNull
    public Bundle getArguments() {
      Bundle __result = new Bundle();
      if (arguments.containsKey("ARGS_CUSTOM_ERROR")) {
        String ARGSCUSTOMERROR = (String) arguments.get("ARGS_CUSTOM_ERROR");
        __result.putString("ARGS_CUSTOM_ERROR", ARGSCUSTOMERROR);
      }
      if (arguments.containsKey("ARGS_DOCUMENT")) {
        Document ARGSDOCUMENT = (Document) arguments.get("ARGS_DOCUMENT");
        if (Parcelable.class.isAssignableFrom(Document.class) || ARGSDOCUMENT == null) {
          __result.putParcelable("ARGS_DOCUMENT", Parcelable.class.cast(ARGSDOCUMENT));
        } else if (Serializable.class.isAssignableFrom(Document.class)) {
          __result.putSerializable("ARGS_DOCUMENT", Serializable.class.cast(ARGSDOCUMENT));
        } else {
          throw new UnsupportedOperationException(Document.class.getName() + " must implement Parcelable or Serializable or must be an Enum.");
        }
      }
      return __result;
    }

    @Override
    public int getActionId() {
      return R.id.to_error_fragment_with_error_message;
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public String getARGSCUSTOMERROR() {
      return (String) arguments.get("ARGS_CUSTOM_ERROR");
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public Document getARGSDOCUMENT() {
      return (Document) arguments.get("ARGS_DOCUMENT");
    }

    @Override
    public boolean equals(Object object) {
      if (this == object) {
          return true;
      }
      if (object == null || getClass() != object.getClass()) {
          return false;
      }
      ToErrorFragmentWithErrorMessage that = (ToErrorFragmentWithErrorMessage) object;
      if (arguments.containsKey("ARGS_CUSTOM_ERROR") != that.arguments.containsKey("ARGS_CUSTOM_ERROR")) {
        return false;
      }
      if (getARGSCUSTOMERROR() != null ? !getARGSCUSTOMERROR().equals(that.getARGSCUSTOMERROR()) : that.getARGSCUSTOMERROR() != null) {
        return false;
      }
      if (arguments.containsKey("ARGS_DOCUMENT") != that.arguments.containsKey("ARGS_DOCUMENT")) {
        return false;
      }
      if (getARGSDOCUMENT() != null ? !getARGSDOCUMENT().equals(that.getARGSDOCUMENT()) : that.getARGSDOCUMENT() != null) {
        return false;
      }
      if (getActionId() != that.getActionId()) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      result = 31 * result + (getARGSCUSTOMERROR() != null ? getARGSCUSTOMERROR().hashCode() : 0);
      result = 31 * result + (getARGSDOCUMENT() != null ? getARGSDOCUMENT().hashCode() : 0);
      result = 31 * result + getActionId();
      return result;
    }

    @Override
    public String toString() {
      return "ToErrorFragmentWithErrorMessage(actionId=" + getActionId() + "){"
          + "ARGSCUSTOMERROR=" + getARGSCUSTOMERROR()
          + ", ARGSDOCUMENT=" + getARGSDOCUMENT()
          + "}";
    }
  }

  public static class ToNoResultsFragment implements NavDirections {
    private final HashMap arguments = new HashMap();

    @SuppressWarnings("unchecked")
    private ToNoResultsFragment(@NonNull Document GCARGSDOCUMENT) {
      if (GCARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_DOCUMENT", GCARGSDOCUMENT);
    }

    @NonNull
    @SuppressWarnings("unchecked")
    public ToNoResultsFragment setGCARGSDOCUMENT(@NonNull Document GCARGSDOCUMENT) {
      if (GCARGSDOCUMENT == null) {
        throw new IllegalArgumentException("Argument \"GC_ARGS_DOCUMENT\" is marked as non-null but was passed a null value.");
      }
      this.arguments.put("GC_ARGS_DOCUMENT", GCARGSDOCUMENT);
      return this;
    }

    @Override
    @SuppressWarnings("unchecked")
    @NonNull
    public Bundle getArguments() {
      Bundle __result = new Bundle();
      if (arguments.containsKey("GC_ARGS_DOCUMENT")) {
        Document GCARGSDOCUMENT = (Document) arguments.get("GC_ARGS_DOCUMENT");
        if (Parcelable.class.isAssignableFrom(Document.class) || GCARGSDOCUMENT == null) {
          __result.putParcelable("GC_ARGS_DOCUMENT", Parcelable.class.cast(GCARGSDOCUMENT));
        } else if (Serializable.class.isAssignableFrom(Document.class)) {
          __result.putSerializable("GC_ARGS_DOCUMENT", Serializable.class.cast(GCARGSDOCUMENT));
        } else {
          throw new UnsupportedOperationException(Document.class.getName() + " must implement Parcelable or Serializable or must be an Enum.");
        }
      }
      return __result;
    }

    @Override
    public int getActionId() {
      return R.id.to_no_results_fragment;
    }

    @SuppressWarnings("unchecked")
    @NonNull
    public Document getGCARGSDOCUMENT() {
      return (Document) arguments.get("GC_ARGS_DOCUMENT");
    }

    @Override
    public boolean equals(Object object) {
      if (this == object) {
          return true;
      }
      if (object == null || getClass() != object.getClass()) {
          return false;
      }
      ToNoResultsFragment that = (ToNoResultsFragment) object;
      if (arguments.containsKey("GC_ARGS_DOCUMENT") != that.arguments.containsKey("GC_ARGS_DOCUMENT")) {
        return false;
      }
      if (getGCARGSDOCUMENT() != null ? !getGCARGSDOCUMENT().equals(that.getGCARGSDOCUMENT()) : that.getGCARGSDOCUMENT() != null) {
        return false;
      }
      if (getActionId() != that.getActionId()) {
        return false;
      }
      return true;
    }

    @Override
    public int hashCode() {
      int result = 1;
      result = 31 * result + (getGCARGSDOCUMENT() != null ? getGCARGSDOCUMENT().hashCode() : 0);
      result = 31 * result + getActionId();
      return result;
    }

    @Override
    public String toString() {
      return "ToNoResultsFragment(actionId=" + getActionId() + "){"
          + "GCARGSDOCUMENT=" + getGCARGSDOCUMENT()
          + "}";
    }
  }
}
