package net.gini.android.capture

/**
 * Enum class represents currently supported currencies.
 * Currency codes are expressed in ISO 4217 standard.
 */
enum class AmountCurrency {
    /**
     * Stands for EURO (official currency of the euro-zone).
     */
    EUR,

    /**
     * Stands for the British pound sterling.
     */
    GBP,

    /**
     * Stands for United States Dollar.
     */
    USD,

    /**
     * Stands for Confoederatio Helvetica franc.
     */
    CHF
}