package net.gini.android.bank.sdk.capture.digitalinvoice

import android.os.Bundle
import android.os.Parcelable
import androidx.lifecycle.SavedStateHandle
import androidx.navigation.NavArgs
import java.io.Serializable
import java.lang.IllegalArgumentException
import java.lang.UnsupportedOperationException
import kotlin.Array
import kotlin.Suppress
import kotlin.jvm.JvmStatic
import net.gini.android.bank.sdk.capture.digitalinvoice.args.ExtractionsResultData
import net.gini.android.bank.sdk.capture.skonto.model.SkontoData
import net.gini.android.bank.sdk.capture.skonto.model.SkontoInvoiceHighlightBoxes

public data class DigitalInvoiceFragmentArgs(
  public val extractionsResult: ExtractionsResultData,
  public val skontoData: SkontoData?,
  public val skontoInvoiceHighlights: Array<SkontoInvoiceHighlightBoxes>,
) : NavArgs {
  @Suppress("CAST_NEVER_SUCCEEDS")
  public fun toBundle(): Bundle {
    val result = Bundle()
    if (Parcelable::class.java.isAssignableFrom(ExtractionsResultData::class.java)) {
      result.putParcelable("extractionsResult", this.extractionsResult as Parcelable)
    } else if (Serializable::class.java.isAssignableFrom(ExtractionsResultData::class.java)) {
      result.putSerializable("extractionsResult", this.extractionsResult as Serializable)
    } else {
      throw UnsupportedOperationException(ExtractionsResultData::class.java.name +
          " must implement Parcelable or Serializable or must be an Enum.")
    }
    if (Parcelable::class.java.isAssignableFrom(SkontoData::class.java)) {
      result.putParcelable("skontoData", this.skontoData as Parcelable?)
    } else if (Serializable::class.java.isAssignableFrom(SkontoData::class.java)) {
      result.putSerializable("skontoData", this.skontoData as Serializable?)
    } else {
      throw UnsupportedOperationException(SkontoData::class.java.name +
          " must implement Parcelable or Serializable or must be an Enum.")
    }
    result.putParcelableArray("skontoInvoiceHighlights", this.skontoInvoiceHighlights)
    return result
  }

  @Suppress("CAST_NEVER_SUCCEEDS")
  public fun toSavedStateHandle(): SavedStateHandle {
    val result = SavedStateHandle()
    if (Parcelable::class.java.isAssignableFrom(ExtractionsResultData::class.java)) {
      result.set("extractionsResult", this.extractionsResult as Parcelable)
    } else if (Serializable::class.java.isAssignableFrom(ExtractionsResultData::class.java)) {
      result.set("extractionsResult", this.extractionsResult as Serializable)
    } else {
      throw UnsupportedOperationException(ExtractionsResultData::class.java.name +
          " must implement Parcelable or Serializable or must be an Enum.")
    }
    if (Parcelable::class.java.isAssignableFrom(SkontoData::class.java)) {
      result.set("skontoData", this.skontoData as Parcelable?)
    } else if (Serializable::class.java.isAssignableFrom(SkontoData::class.java)) {
      result.set("skontoData", this.skontoData as Serializable?)
    } else {
      throw UnsupportedOperationException(SkontoData::class.java.name +
          " must implement Parcelable or Serializable or must be an Enum.")
    }
    result.set("skontoInvoiceHighlights", this.skontoInvoiceHighlights)
    return result
  }

  public companion object {
    @JvmStatic
    @Suppress("UNCHECKED_CAST","DEPRECATION")
    public fun fromBundle(bundle: Bundle): DigitalInvoiceFragmentArgs {
      bundle.setClassLoader(DigitalInvoiceFragmentArgs::class.java.classLoader)
      val __extractionsResult : ExtractionsResultData?
      if (bundle.containsKey("extractionsResult")) {
        if (Parcelable::class.java.isAssignableFrom(ExtractionsResultData::class.java) ||
            Serializable::class.java.isAssignableFrom(ExtractionsResultData::class.java)) {
          __extractionsResult = bundle.get("extractionsResult") as ExtractionsResultData?
        } else {
          throw UnsupportedOperationException(ExtractionsResultData::class.java.name +
              " must implement Parcelable or Serializable or must be an Enum.")
        }
        if (__extractionsResult == null) {
          throw IllegalArgumentException("Argument \"extractionsResult\" is marked as non-null but was passed a null value.")
        }
      } else {
        throw IllegalArgumentException("Required argument \"extractionsResult\" is missing and does not have an android:defaultValue")
      }
      val __skontoData : SkontoData?
      if (bundle.containsKey("skontoData")) {
        if (Parcelable::class.java.isAssignableFrom(SkontoData::class.java) ||
            Serializable::class.java.isAssignableFrom(SkontoData::class.java)) {
          __skontoData = bundle.get("skontoData") as SkontoData?
        } else {
          throw UnsupportedOperationException(SkontoData::class.java.name +
              " must implement Parcelable or Serializable or must be an Enum.")
        }
      } else {
        throw IllegalArgumentException("Required argument \"skontoData\" is missing and does not have an android:defaultValue")
      }
      val __skontoInvoiceHighlights : Array<SkontoInvoiceHighlightBoxes>?
      if (bundle.containsKey("skontoInvoiceHighlights")) {
        __skontoInvoiceHighlights = bundle.getParcelableArray("skontoInvoiceHighlights")?.map { it
            as SkontoInvoiceHighlightBoxes }?.toTypedArray()
        if (__skontoInvoiceHighlights == null) {
          throw IllegalArgumentException("Argument \"skontoInvoiceHighlights\" is marked as non-null but was passed a null value.")
        }
      } else {
        throw IllegalArgumentException("Required argument \"skontoInvoiceHighlights\" is missing and does not have an android:defaultValue")
      }
      return DigitalInvoiceFragmentArgs(__extractionsResult, __skontoData,
          __skontoInvoiceHighlights)
    }

    @JvmStatic
    public fun fromSavedStateHandle(savedStateHandle: SavedStateHandle):
        DigitalInvoiceFragmentArgs {
      val __extractionsResult : ExtractionsResultData?
      if (savedStateHandle.contains("extractionsResult")) {
        if (Parcelable::class.java.isAssignableFrom(ExtractionsResultData::class.java) ||
            Serializable::class.java.isAssignableFrom(ExtractionsResultData::class.java)) {
          __extractionsResult = savedStateHandle.get<ExtractionsResultData?>("extractionsResult")
        } else {
          throw UnsupportedOperationException(ExtractionsResultData::class.java.name +
              " must implement Parcelable or Serializable or must be an Enum.")
        }
        if (__extractionsResult == null) {
          throw IllegalArgumentException("Argument \"extractionsResult\" is marked as non-null but was passed a null value")
        }
      } else {
        throw IllegalArgumentException("Required argument \"extractionsResult\" is missing and does not have an android:defaultValue")
      }
      val __skontoData : SkontoData?
      if (savedStateHandle.contains("skontoData")) {
        if (Parcelable::class.java.isAssignableFrom(SkontoData::class.java) ||
            Serializable::class.java.isAssignableFrom(SkontoData::class.java)) {
          __skontoData = savedStateHandle.get<SkontoData?>("skontoData")
        } else {
          throw UnsupportedOperationException(SkontoData::class.java.name +
              " must implement Parcelable or Serializable or must be an Enum.")
        }
      } else {
        throw IllegalArgumentException("Required argument \"skontoData\" is missing and does not have an android:defaultValue")
      }
      val __skontoInvoiceHighlights : Array<SkontoInvoiceHighlightBoxes>?
      if (savedStateHandle.contains("skontoInvoiceHighlights")) {
        __skontoInvoiceHighlights =
            savedStateHandle.get<Array<Parcelable>>("skontoInvoiceHighlights")?.map { it as
            SkontoInvoiceHighlightBoxes }?.toTypedArray()
        if (__skontoInvoiceHighlights == null) {
          throw IllegalArgumentException("Argument \"skontoInvoiceHighlights\" is marked as non-null but was passed a null value")
        }
      } else {
        throw IllegalArgumentException("Required argument \"skontoInvoiceHighlights\" is missing and does not have an android:defaultValue")
      }
      return DigitalInvoiceFragmentArgs(__extractionsResult, __skontoData,
          __skontoInvoiceHighlights)
    }
  }
}
