package net.gini.android.bank.sdk.capture.skonto

import android.os.Bundle
import androidx.navigation.ActionOnlyNavDirections
import androidx.navigation.NavDirections
import kotlin.Array
import kotlin.Int
import kotlin.String
import net.gini.android.bank.sdk.R
import net.gini.android.capture.network.model.GiniCaptureBox

public class SkontoFragmentDirections private constructor() {
  private data class ToInvoicePreviewFragment(
    public val screenTitle: String,
    public val documentId: String,
    public val infoTextLines: Array<String>?,
    public val highlightBoxes: Array<GiniCaptureBox>,
  ) : NavDirections {
    public override val actionId: Int = R.id.to_invoice_preview_fragment

    public override val arguments: Bundle
      get() {
        val result = Bundle()
        result.putString("screen_title", this.screenTitle)
        result.putString("document_id", this.documentId)
        result.putStringArray("info_text_lines", this.infoTextLines)
        result.putParcelableArray("highlight_boxes", this.highlightBoxes)
        return result
      }
  }

  public companion object {
    public fun toCaptureFragment(): NavDirections =
        ActionOnlyNavDirections(R.id.to_capture_fragment)

    public fun toInvoicePreviewFragment(
      screenTitle: String,
      documentId: String,
      infoTextLines: Array<String>?,
      highlightBoxes: Array<GiniCaptureBox>,
    ): NavDirections = ToInvoicePreviewFragment(screenTitle, documentId, infoTextLines,
        highlightBoxes)

    public fun toSkontoHelpFragment(): NavDirections =
        ActionOnlyNavDirections(R.id.to_skonto_help_fragment)
  }
}
