package net.gini.android.bank.sdk.invoice

import android.os.Bundle
import android.os.Parcelable
import androidx.lifecycle.SavedStateHandle
import androidx.navigation.NavArgs
import java.lang.IllegalArgumentException
import kotlin.Array
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmStatic
import net.gini.android.capture.network.model.GiniCaptureBox

public data class InvoicePreviewFragmentArgs(
  public val screenTitle: String,
  public val documentId: String,
  public val infoTextLines: Array<String>?,
  public val highlightBoxes: Array<GiniCaptureBox>,
) : NavArgs {
  public fun toBundle(): Bundle {
    val result = Bundle()
    result.putString("screen_title", this.screenTitle)
    result.putString("document_id", this.documentId)
    result.putStringArray("info_text_lines", this.infoTextLines)
    result.putParcelableArray("highlight_boxes", this.highlightBoxes)
    return result
  }

  public fun toSavedStateHandle(): SavedStateHandle {
    val result = SavedStateHandle()
    result.set("screen_title", this.screenTitle)
    result.set("document_id", this.documentId)
    result.set("info_text_lines", this.infoTextLines)
    result.set("highlight_boxes", this.highlightBoxes)
    return result
  }

  public companion object {
    @JvmStatic
    @Suppress("UNCHECKED_CAST","DEPRECATION")
    public fun fromBundle(bundle: Bundle): InvoicePreviewFragmentArgs {
      bundle.setClassLoader(InvoicePreviewFragmentArgs::class.java.classLoader)
      val __screenTitle : String?
      if (bundle.containsKey("screen_title")) {
        __screenTitle = bundle.getString("screen_title")
        if (__screenTitle == null) {
          throw IllegalArgumentException("Argument \"screen_title\" is marked as non-null but was passed a null value.")
        }
      } else {
        throw IllegalArgumentException("Required argument \"screen_title\" is missing and does not have an android:defaultValue")
      }
      val __documentId : String?
      if (bundle.containsKey("document_id")) {
        __documentId = bundle.getString("document_id")
        if (__documentId == null) {
          throw IllegalArgumentException("Argument \"document_id\" is marked as non-null but was passed a null value.")
        }
      } else {
        throw IllegalArgumentException("Required argument \"document_id\" is missing and does not have an android:defaultValue")
      }
      val __infoTextLines : Array<String>?
      if (bundle.containsKey("info_text_lines")) {
        __infoTextLines = bundle.getStringArray("info_text_lines")
      } else {
        throw IllegalArgumentException("Required argument \"info_text_lines\" is missing and does not have an android:defaultValue")
      }
      val __highlightBoxes : Array<GiniCaptureBox>?
      if (bundle.containsKey("highlight_boxes")) {
        __highlightBoxes = bundle.getParcelableArray("highlight_boxes")?.map { it as GiniCaptureBox
            }?.toTypedArray()
        if (__highlightBoxes == null) {
          throw IllegalArgumentException("Argument \"highlight_boxes\" is marked as non-null but was passed a null value.")
        }
      } else {
        throw IllegalArgumentException("Required argument \"highlight_boxes\" is missing and does not have an android:defaultValue")
      }
      return InvoicePreviewFragmentArgs(__screenTitle, __documentId, __infoTextLines,
          __highlightBoxes)
    }

    @JvmStatic
    public fun fromSavedStateHandle(savedStateHandle: SavedStateHandle):
        InvoicePreviewFragmentArgs {
      val __screenTitle : String?
      if (savedStateHandle.contains("screen_title")) {
        __screenTitle = savedStateHandle["screen_title"]
        if (__screenTitle == null) {
          throw IllegalArgumentException("Argument \"screen_title\" is marked as non-null but was passed a null value")
        }
      } else {
        throw IllegalArgumentException("Required argument \"screen_title\" is missing and does not have an android:defaultValue")
      }
      val __documentId : String?
      if (savedStateHandle.contains("document_id")) {
        __documentId = savedStateHandle["document_id"]
        if (__documentId == null) {
          throw IllegalArgumentException("Argument \"document_id\" is marked as non-null but was passed a null value")
        }
      } else {
        throw IllegalArgumentException("Required argument \"document_id\" is missing and does not have an android:defaultValue")
      }
      val __infoTextLines : Array<String>?
      if (savedStateHandle.contains("info_text_lines")) {
        __infoTextLines = savedStateHandle["info_text_lines"]
      } else {
        throw IllegalArgumentException("Required argument \"info_text_lines\" is missing and does not have an android:defaultValue")
      }
      val __highlightBoxes : Array<GiniCaptureBox>?
      if (savedStateHandle.contains("highlight_boxes")) {
        __highlightBoxes = savedStateHandle.get<Array<Parcelable>>("highlight_boxes")?.map { it as
            GiniCaptureBox }?.toTypedArray()
        if (__highlightBoxes == null) {
          throw IllegalArgumentException("Argument \"highlight_boxes\" is marked as non-null but was passed a null value")
        }
      } else {
        throw IllegalArgumentException("Required argument \"highlight_boxes\" is missing and does not have an android:defaultValue")
      }
      return InvoicePreviewFragmentArgs(__screenTitle, __documentId, __infoTextLines,
          __highlightBoxes)
    }
  }
}
