package net.gini.android.capture

import android.os.Bundle
import android.os.Parcelable
import androidx.navigation.NavDirections
import java.io.Serializable
import java.lang.UnsupportedOperationException
import kotlin.Array
import kotlin.Int
import kotlin.Suppress
import net.gini.android.bank.sdk.R
import net.gini.android.bank.sdk.capture.digitalinvoice.args.ExtractionsResultData
import net.gini.android.bank.sdk.capture.skonto.model.SkontoData
import net.gini.android.bank.sdk.capture.skonto.model.SkontoInvoiceHighlightBoxes

public class GiniCaptureFragmentDirections private constructor() {
  private data class ToDigitalInvoiceFragment(
    public val extractionsResult: ExtractionsResultData,
    public val skontoData: SkontoData?,
    public val skontoInvoiceHighlights: Array<SkontoInvoiceHighlightBoxes>,
  ) : NavDirections {
    public override val actionId: Int = R.id.to_digital_invoice_fragment

    public override val arguments: Bundle
      @Suppress("CAST_NEVER_SUCCEEDS")
      get() {
        val result = Bundle()
        if (Parcelable::class.java.isAssignableFrom(ExtractionsResultData::class.java)) {
          result.putParcelable("extractionsResult", this.extractionsResult as Parcelable)
        } else if (Serializable::class.java.isAssignableFrom(ExtractionsResultData::class.java)) {
          result.putSerializable("extractionsResult", this.extractionsResult as Serializable)
        } else {
          throw UnsupportedOperationException(ExtractionsResultData::class.java.name +
              " must implement Parcelable or Serializable or must be an Enum.")
        }
        if (Parcelable::class.java.isAssignableFrom(SkontoData::class.java)) {
          result.putParcelable("skontoData", this.skontoData as Parcelable?)
        } else if (Serializable::class.java.isAssignableFrom(SkontoData::class.java)) {
          result.putSerializable("skontoData", this.skontoData as Serializable?)
        } else {
          throw UnsupportedOperationException(SkontoData::class.java.name +
              " must implement Parcelable or Serializable or must be an Enum.")
        }
        result.putParcelableArray("skontoInvoiceHighlights", this.skontoInvoiceHighlights)
        return result
      }
  }

  private data class ToSkontoFragment(
    public val `data`: SkontoData,
    public val invoiceHighlights: Array<SkontoInvoiceHighlightBoxes>,
  ) : NavDirections {
    public override val actionId: Int = R.id.to_skonto_fragment

    public override val arguments: Bundle
      @Suppress("CAST_NEVER_SUCCEEDS")
      get() {
        val result = Bundle()
        if (Parcelable::class.java.isAssignableFrom(SkontoData::class.java)) {
          result.putParcelable("data", this.data as Parcelable)
        } else if (Serializable::class.java.isAssignableFrom(SkontoData::class.java)) {
          result.putSerializable("data", this.data as Serializable)
        } else {
          throw UnsupportedOperationException(SkontoData::class.java.name +
              " must implement Parcelable or Serializable or must be an Enum.")
        }
        result.putParcelableArray("invoiceHighlights", this.invoiceHighlights)
        return result
      }
  }

  public companion object {
    public fun toDigitalInvoiceFragment(
      extractionsResult: ExtractionsResultData,
      skontoData: SkontoData?,
      skontoInvoiceHighlights: Array<SkontoInvoiceHighlightBoxes>,
    ): NavDirections = ToDigitalInvoiceFragment(extractionsResult, skontoData,
        skontoInvoiceHighlights)

    public fun toSkontoFragment(`data`: SkontoData,
        invoiceHighlights: Array<SkontoInvoiceHighlightBoxes>): NavDirections =
        ToSkontoFragment(data, invoiceHighlights)
  }
}
