package net.gini.android.bank.sdk.capture.skonto.invoice

import android.os.Bundle
import android.os.Parcelable
import androidx.lifecycle.SavedStateHandle
import androidx.navigation.NavArgs
import java.io.Serializable
import java.lang.IllegalArgumentException
import java.lang.UnsupportedOperationException
import kotlin.Array
import kotlin.Suppress
import kotlin.jvm.JvmStatic
import net.gini.android.bank.sdk.capture.skonto.model.SkontoData
import net.gini.android.bank.sdk.capture.skonto.model.SkontoInvoiceHighlightBoxes

public data class SkontoInvoiceFragmentArgs(
  public val skontoData: SkontoData?,
  public val invoiceHighlights: Array<SkontoInvoiceHighlightBoxes>,
) : NavArgs {
  @Suppress("CAST_NEVER_SUCCEEDS")
  public fun toBundle(): Bundle {
    val result = Bundle()
    if (Parcelable::class.java.isAssignableFrom(SkontoData::class.java)) {
      result.putParcelable("skonto_data", this.skontoData as Parcelable?)
    } else if (Serializable::class.java.isAssignableFrom(SkontoData::class.java)) {
      result.putSerializable("skonto_data", this.skontoData as Serializable?)
    } else {
      throw UnsupportedOperationException(SkontoData::class.java.name +
          " must implement Parcelable or Serializable or must be an Enum.")
    }
    result.putParcelableArray("invoiceHighlights", this.invoiceHighlights)
    return result
  }

  @Suppress("CAST_NEVER_SUCCEEDS")
  public fun toSavedStateHandle(): SavedStateHandle {
    val result = SavedStateHandle()
    if (Parcelable::class.java.isAssignableFrom(SkontoData::class.java)) {
      result.set("skonto_data", this.skontoData as Parcelable?)
    } else if (Serializable::class.java.isAssignableFrom(SkontoData::class.java)) {
      result.set("skonto_data", this.skontoData as Serializable?)
    } else {
      throw UnsupportedOperationException(SkontoData::class.java.name +
          " must implement Parcelable or Serializable or must be an Enum.")
    }
    result.set("invoiceHighlights", this.invoiceHighlights)
    return result
  }

  public companion object {
    @JvmStatic
    @Suppress("UNCHECKED_CAST","DEPRECATION")
    public fun fromBundle(bundle: Bundle): SkontoInvoiceFragmentArgs {
      bundle.setClassLoader(SkontoInvoiceFragmentArgs::class.java.classLoader)
      val __skontoData : SkontoData?
      if (bundle.containsKey("skonto_data")) {
        if (Parcelable::class.java.isAssignableFrom(SkontoData::class.java) ||
            Serializable::class.java.isAssignableFrom(SkontoData::class.java)) {
          __skontoData = bundle.get("skonto_data") as SkontoData?
        } else {
          throw UnsupportedOperationException(SkontoData::class.java.name +
              " must implement Parcelable or Serializable or must be an Enum.")
        }
      } else {
        throw IllegalArgumentException("Required argument \"skonto_data\" is missing and does not have an android:defaultValue")
      }
      val __invoiceHighlights : Array<SkontoInvoiceHighlightBoxes>?
      if (bundle.containsKey("invoiceHighlights")) {
        __invoiceHighlights = bundle.getParcelableArray("invoiceHighlights")?.map { it as
            SkontoInvoiceHighlightBoxes }?.toTypedArray()
        if (__invoiceHighlights == null) {
          throw IllegalArgumentException("Argument \"invoiceHighlights\" is marked as non-null but was passed a null value.")
        }
      } else {
        throw IllegalArgumentException("Required argument \"invoiceHighlights\" is missing and does not have an android:defaultValue")
      }
      return SkontoInvoiceFragmentArgs(__skontoData, __invoiceHighlights)
    }

    @JvmStatic
    public fun fromSavedStateHandle(savedStateHandle: SavedStateHandle): SkontoInvoiceFragmentArgs {
      val __skontoData : SkontoData?
      if (savedStateHandle.contains("skonto_data")) {
        if (Parcelable::class.java.isAssignableFrom(SkontoData::class.java) ||
            Serializable::class.java.isAssignableFrom(SkontoData::class.java)) {
          __skontoData = savedStateHandle.get<SkontoData?>("skonto_data")
        } else {
          throw UnsupportedOperationException(SkontoData::class.java.name +
              " must implement Parcelable or Serializable or must be an Enum.")
        }
      } else {
        throw IllegalArgumentException("Required argument \"skonto_data\" is missing and does not have an android:defaultValue")
      }
      val __invoiceHighlights : Array<SkontoInvoiceHighlightBoxes>?
      if (savedStateHandle.contains("invoiceHighlights")) {
        __invoiceHighlights = savedStateHandle.get<Array<Parcelable>>("invoiceHighlights")?.map { it
            as SkontoInvoiceHighlightBoxes }?.toTypedArray()
        if (__invoiceHighlights == null) {
          throw IllegalArgumentException("Argument \"invoiceHighlights\" is marked as non-null but was passed a null value")
        }
      } else {
        throw IllegalArgumentException("Required argument \"invoiceHighlights\" is missing and does not have an android:defaultValue")
      }
      return SkontoInvoiceFragmentArgs(__skontoData, __invoiceHighlights)
    }
  }
}
