package net.gini.android.bank.sdk.capture.digitalinvoice.skonto

import android.os.Bundle
import android.os.Parcelable
import androidx.navigation.ActionOnlyNavDirections
import androidx.navigation.NavDirections
import java.io.Serializable
import java.lang.UnsupportedOperationException
import kotlin.Array
import kotlin.Int
import kotlin.Suppress
import net.gini.android.bank.sdk.R
import net.gini.android.bank.sdk.capture.skonto.model.SkontoData
import net.gini.android.bank.sdk.capture.skonto.model.SkontoInvoiceHighlightBoxes

public class DigitalInvoiceSkontoFragmentDirections private constructor() {
  private data class ToSkontoInvoiceFragment(
    public val skontoData: SkontoData?,
    public val invoiceHighlights: Array<SkontoInvoiceHighlightBoxes>,
  ) : NavDirections {
    public override val actionId: Int = R.id.to_skonto_invoice_fragment

    public override val arguments: Bundle
      @Suppress("CAST_NEVER_SUCCEEDS")
      get() {
        val result = Bundle()
        if (Parcelable::class.java.isAssignableFrom(SkontoData::class.java)) {
          result.putParcelable("skonto_data", this.skontoData as Parcelable?)
        } else if (Serializable::class.java.isAssignableFrom(SkontoData::class.java)) {
          result.putSerializable("skonto_data", this.skontoData as Serializable?)
        } else {
          throw UnsupportedOperationException(SkontoData::class.java.name +
              " must implement Parcelable or Serializable or must be an Enum.")
        }
        result.putParcelableArray("invoiceHighlights", this.invoiceHighlights)
        return result
      }
  }

  public companion object {
    public fun toSkontoInvoiceFragment(skontoData: SkontoData?,
        invoiceHighlights: Array<SkontoInvoiceHighlightBoxes>): NavDirections =
        ToSkontoInvoiceFragment(skontoData, invoiceHighlights)

    public fun toSkontoHelpFragment(): NavDirections =
        ActionOnlyNavDirections(R.id.to_skonto_help_fragment)
  }
}
