package net.gini.android.capture

import android.os.Bundle
import android.os.Parcelable
import androidx.navigation.NavDirections
import java.io.Serializable
import java.lang.UnsupportedOperationException
import kotlin.Array
import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import net.gini.android.bank.sdk.R
import net.gini.android.bank.sdk.capture.skonto.model.SkontoData
import net.gini.android.capture.network.model.GiniCaptureReturnReason

public class GiniCaptureFragmentDirections private constructor() {
  private data class ToDigitalInvoiceFragment(
    public val GBSARGSEXTRACTIONS: Bundle,
    public val GBSARGSCOMPOUNDEXTRACTIONS: Bundle,
    public val GBSARGSRETURNREASONS: Array<GiniCaptureReturnReason>,
    public val GBSARGSINACCURATEEXTRACTION: Boolean,
  ) : NavDirections {
    public override val actionId: Int = R.id.to_digital_invoice_fragment

    public override val arguments: Bundle
      @Suppress("CAST_NEVER_SUCCEEDS")
      get() {
        val result = Bundle()
        if (Parcelable::class.java.isAssignableFrom(Bundle::class.java)) {
          result.putParcelable("GBS_ARGS_EXTRACTIONS", this.GBSARGSEXTRACTIONS as Parcelable)
        } else if (Serializable::class.java.isAssignableFrom(Bundle::class.java)) {
          result.putSerializable("GBS_ARGS_EXTRACTIONS", this.GBSARGSEXTRACTIONS as Serializable)
        } else {
          throw UnsupportedOperationException(Bundle::class.java.name +
              " must implement Parcelable or Serializable or must be an Enum.")
        }
        if (Parcelable::class.java.isAssignableFrom(Bundle::class.java)) {
          result.putParcelable("GBS_ARGS_COMPOUND_EXTRACTIONS", this.GBSARGSCOMPOUNDEXTRACTIONS as
              Parcelable)
        } else if (Serializable::class.java.isAssignableFrom(Bundle::class.java)) {
          result.putSerializable("GBS_ARGS_COMPOUND_EXTRACTIONS", this.GBSARGSCOMPOUNDEXTRACTIONS as
              Serializable)
        } else {
          throw UnsupportedOperationException(Bundle::class.java.name +
              " must implement Parcelable or Serializable or must be an Enum.")
        }
        result.putParcelableArray("GBS_ARGS_RETURN_REASONS", this.GBSARGSRETURNREASONS)
        result.putBoolean("GBS_ARGS_INACCURATE_EXTRACTION", this.GBSARGSINACCURATEEXTRACTION)
        return result
      }
  }

  private data class ToSkontoFragment(
    public val `data`: SkontoData,
  ) : NavDirections {
    public override val actionId: Int = R.id.to_skonto_fragment

    public override val arguments: Bundle
      @Suppress("CAST_NEVER_SUCCEEDS")
      get() {
        val result = Bundle()
        if (Parcelable::class.java.isAssignableFrom(SkontoData::class.java)) {
          result.putParcelable("data", this.data as Parcelable)
        } else if (Serializable::class.java.isAssignableFrom(SkontoData::class.java)) {
          result.putSerializable("data", this.data as Serializable)
        } else {
          throw UnsupportedOperationException(SkontoData::class.java.name +
              " must implement Parcelable or Serializable or must be an Enum.")
        }
        return result
      }
  }

  public companion object {
    public fun toDigitalInvoiceFragment(
      GBSARGSEXTRACTIONS: Bundle,
      GBSARGSCOMPOUNDEXTRACTIONS: Bundle,
      GBSARGSRETURNREASONS: Array<GiniCaptureReturnReason>,
      GBSARGSINACCURATEEXTRACTION: Boolean,
    ): NavDirections = ToDigitalInvoiceFragment(GBSARGSEXTRACTIONS, GBSARGSCOMPOUNDEXTRACTIONS,
        GBSARGSRETURNREASONS, GBSARGSINACCURATEEXTRACTION)

    public fun toSkontoFragment(`data`: SkontoData): NavDirections = ToSkontoFragment(data)
  }
}
