package net.gini.android.bank.sdk.capture.digitalinvoice

import android.os.Bundle
import android.os.Parcelable
import androidx.navigation.ActionOnlyNavDirections
import androidx.navigation.NavDirections
import java.io.Serializable
import java.lang.UnsupportedOperationException
import kotlin.Int
import kotlin.Suppress
import net.gini.android.bank.sdk.R

public class DigitalInvoiceFragmentDirections private constructor() {
  private data class ToDigitalInvoiceEditItemBottomSheetDialog(
    public val GBSARGSSELECTABLELINEITEM: SelectableLineItem,
  ) : NavDirections {
    public override val actionId: Int = R.id.to_digital_invoice_edit_item_bottom_sheet_dialog

    public override val arguments: Bundle
      @Suppress("CAST_NEVER_SUCCEEDS")
      get() {
        val result = Bundle()
        if (Parcelable::class.java.isAssignableFrom(SelectableLineItem::class.java)) {
          result.putParcelable("GBS_ARGS_SELECTABLE_LINE_ITEM", this.GBSARGSSELECTABLELINEITEM as
              Parcelable)
        } else if (Serializable::class.java.isAssignableFrom(SelectableLineItem::class.java)) {
          result.putSerializable("GBS_ARGS_SELECTABLE_LINE_ITEM", this.GBSARGSSELECTABLELINEITEM as
              Serializable)
        } else {
          throw UnsupportedOperationException(SelectableLineItem::class.java.name +
              " must implement Parcelable or Serializable or must be an Enum.")
        }
        return result
      }
  }

  public companion object {
    public fun toDigitalInvoiceOnboardingFragment(): NavDirections =
        ActionOnlyNavDirections(R.id.to_digital_invoice_onboarding_fragment)

    public fun toDigitalInvoiceHelpFragment(): NavDirections =
        ActionOnlyNavDirections(R.id.to_digital_invoice_help_fragment)

    public
        fun toDigitalInvoiceEditItemBottomSheetDialog(GBSARGSSELECTABLELINEITEM: SelectableLineItem):
        NavDirections = ToDigitalInvoiceEditItemBottomSheetDialog(GBSARGSSELECTABLELINEITEM)
  }
}
