/*
 * Decompiled with CFR 0.152.
 */
package net.gcolin.httpquery;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import net.gcolin.httpquery.AbstractElement;
import net.gcolin.httpquery.Deserializer;
import net.gcolin.httpquery.HttpClientDeserializers;
import net.gcolin.httpquery.Response;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class ResponseImpl
extends AbstractElement
implements Response {
    private HttpResponse response;
    private Deserializer deserializer;

    public ResponseImpl(HttpResponse response, Deserializer deserializer) {
        this.response = response;
        this.deserializer = deserializer;
    }

    public <T> T as(Class<T> target) {
        return this.callback(HttpClientDeserializers.object(target, this.deserializer));
    }

    public String asString() {
        return this.callback(HttpClientDeserializers.STRING);
    }

    public byte[] asBytes() {
        return this.callback(HttpClientDeserializers.BYTE);
    }

    public InputStream asStream() {
        return this.callback(HttpClientDeserializers.STREAM);
    }

    public String header(String key) {
        return this.response.getFirstHeader(key).getValue();
    }

    @Override
    public HttpResponse getResponse() {
        return this.response;
    }

    public void close() {
        this.close(this.response.getEntity());
    }

    public Collection<String> headers(String key) {
        ArrayList<String> list = new ArrayList<String>();
        for (Header h : this.response.getHeaders(key)) {
            list.add(h.getValue());
        }
        return list;
    }

    public Collection<Map.Entry<String, String>> headers() {
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>();
        for (Header h : this.response.getAllHeaders()) {
            list.add(new HeaderEntry(h));
        }
        return list;
    }

    public int status() {
        return this.response.getStatusLine().getStatusCode();
    }

    private static final class HeaderEntry
    implements Map.Entry<String, String> {
        private final Header header;
        private String v;

        public HeaderEntry(Header h) {
            this.header = h;
            this.v = h.getValue();
        }

        @Override
        public String setValue(String value) {
            String old = this.v;
            this.v = value;
            return old;
        }

        @Override
        public String getValue() {
            return this.header.getValue();
        }

        @Override
        public String getKey() {
            return this.header.getName();
        }
    }
}

