/*
 * Decompiled with CFR 0.152.
 */
package net.gcolin.httpquery;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.gcolin.httpquery.IO;
import net.gcolin.httpquery.Request;
import net.gcolin.httpquery.RequestImpl;
import net.gcolin.httpquery.RequestWithPayload;
import net.gcolin.httpquery.Serializer;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.ByteArrayEntity;
import org.slf4j.LoggerFactory;

public class RequestWithPayloadImpl
implements RequestWithPayload {
    private HttpEntityEnclosingRequestBase delegate;
    private Object obj;

    public RequestWithPayloadImpl(HttpEntityEnclosingRequestBase delegate, Object obj) {
        this.delegate = delegate;
        this.obj = obj;
    }

    public Request serializeWith(Serializer s) {
        if (s != null) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                s.write((OutputStream)out, this.obj);
                this.delegate.setEntity((HttpEntity)new ByteArrayEntity(out.toByteArray()));
                String type = IO.contentType((Object)s);
                if (type != null) {
                    this.delegate.addHeader("Content-Type", type);
                }
            }
            catch (IOException e) {
                LoggerFactory.getLogger(this.getClass()).error(e.getMessage(), (Throwable)e);
            }
        }
        return new RequestImpl((HttpRequestBase)this.delegate);
    }

    public Request serialize() {
        return this.serializeWith(IO.serializerAs(this.obj.getClass()));
    }

    public Request serializeWith(Class<? extends Serializer> serializer) {
        return this.serializeWith(IO.serializer(serializer));
    }
}

