/*
 * Decompiled with CFR 0.152.
 */
package net.gcolin.httpquery;

import java.io.IOException;
import java.io.InputStream;
import net.gcolin.httpquery.AbstractElement;
import net.gcolin.httpquery.Deserializer;
import net.gcolin.httpquery.HttpClientDeserializers;
import net.gcolin.httpquery.IO;
import net.gcolin.httpquery.Request;
import net.gcolin.httpquery.Response;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;

public class RequestImpl
extends AbstractElement
implements Request {
    private HttpRequestBase delegate;
    private Deserializer deserializer;
    private static HttpClient http = new BaseClient();

    public RequestImpl(HttpRequestBase delegate) {
        this.delegate = delegate;
    }

    public <T> T as(Class<T> target) {
        return this.callback(HttpClientDeserializers.object(target, this.deserializer));
    }

    public String asString() {
        return this.callback(HttpClientDeserializers.STRING);
    }

    public byte[] asBytes() {
        return this.callback(HttpClientDeserializers.BYTE);
    }

    public InputStream asStream() {
        return this.callback(HttpClientDeserializers.STREAM);
    }

    public Response asResponse() {
        return this.callback(HttpClientDeserializers.reponse(this.deserializer));
    }

    public RequestImpl setContentType(String s) {
        this.delegate.addHeader("Content-Type", s);
        return this;
    }

    public Request setAcceptType(String s) {
        return this.header("Accept", s);
    }

    public Request deserializeWith(Deserializer p) {
        this.deserializer = p;
        return this;
    }

    public Request setAuthBasic(String username, String password) {
        return this.header("Authorization", "Basic " + Base64.encodeBase64((byte[])(username + ":" + password).getBytes()));
    }

    @Override
    protected HttpResponse getResponse() throws IOException {
        return http.execute((HttpUriRequest)this.delegate);
    }

    public Request header(String key, String value) {
        this.delegate.addHeader(key, value);
        return this;
    }

    public Request deserializeWith(Class<? extends Deserializer> p) {
        this.deserializer = IO.deserializer(p);
        return this;
    }

    private static class BaseClient
    extends DefaultHttpClient {
        private static final int HTTPS = 443;
        private static final int HTTP = 80;

        private BaseClient() {
        }

        protected ClientConnectionManager createClientConnectionManager() {
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
            registry.register(new Scheme("https", 443, (SchemeSocketFactory)SSLSocketFactory.getSocketFactory()));
            return new PoolingClientConnectionManager(registry);
        }
    }
}

