/*
 * Decompiled with CFR 0.152.
 */
package net.gcolin.httpquery;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import net.gcolin.httpquery.Http;
import net.gcolin.httpquery.HttpHandler;
import net.gcolin.httpquery.Request;
import net.gcolin.httpquery.RequestImpl;
import net.gcolin.httpquery.RequestWithPayload;
import net.gcolin.httpquery.RequestWithPayloadImpl;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpTrace;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.slf4j.LoggerFactory;

public class HttpHandlerImpl
implements HttpHandler {
    public static final String ERROR_MESSAGE = "cannot send request";

    public Request get(String uri) {
        return new RequestImpl((HttpRequestBase)new HttpGet(uri));
    }

    public Request delete(String uri) {
        return new RequestImpl((HttpRequestBase)new HttpDelete(uri));
    }

    public RequestWithPayload put(String uri, Object obj) {
        return new RequestWithPayloadImpl((HttpEntityEnclosingRequestBase)new HttpPut(uri), obj);
    }

    public Request put(String uri, byte[] data) {
        HttpPut put = new HttpPut(uri);
        put.setEntity((HttpEntity)new ByteArrayEntity(data));
        return new RequestImpl((HttpRequestBase)put);
    }

    public Request put(String uri, String str) {
        HttpPut put = new HttpPut(uri);
        try {
            put.setEntity((HttpEntity)new StringEntity(str));
        }
        catch (UnsupportedEncodingException e) {
            LoggerFactory.getLogger(Http.class).error(e.getMessage(), (Throwable)e);
        }
        return new RequestImpl((HttpRequestBase)put);
    }

    public Request put(String uri, InputStream inStream) {
        HttpPut put = new HttpPut(uri);
        put.setEntity((HttpEntity)new InputStreamEntity(inStream, -1L));
        return new RequestImpl((HttpRequestBase)put);
    }

    public RequestWithPayload post(String uri, Object obj) {
        return new RequestWithPayloadImpl((HttpEntityEnclosingRequestBase)new HttpPost(uri), obj);
    }

    public Request post(String uri, byte[] data) {
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)new ByteArrayEntity(data));
        return new RequestImpl((HttpRequestBase)post);
    }

    public Request post(String uri, InputStream inStream) {
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)new InputStreamEntity(inStream, -1L));
        return new RequestImpl((HttpRequestBase)post);
    }

    public Request post(String uri, String str) {
        HttpPost post = new HttpPost(uri);
        try {
            post.setEntity((HttpEntity)new StringEntity(str));
        }
        catch (UnsupportedEncodingException e) {
            LoggerFactory.getLogger(Http.class).error(e.getMessage(), (Throwable)e);
        }
        return new RequestImpl((HttpRequestBase)post);
    }

    public Request trace(String uri) {
        return new RequestImpl((HttpRequestBase)new HttpTrace(uri));
    }

    public Request head(String uri) {
        return new RequestImpl((HttpRequestBase)new HttpHead(uri));
    }

    public Request options(String uri) {
        return new RequestImpl((HttpRequestBase)new HttpOptions(uri));
    }
}

