/*
 * Decompiled with CFR 0.152.
 */
package net.gcolin.httpquery;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.gcolin.httpquery.Deserializer;
import net.gcolin.httpquery.HttpClientDeserializer;
import net.gcolin.httpquery.IO;
import net.gcolin.httpquery.Response;
import net.gcolin.httpquery.ResponseImpl;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;

public final class HttpClientDeserializers {
    public static final HttpClientDeserializer<String> STRING = new HttpClientDeserializer<String>(){

        @Override
        public String call(HttpEntity entity, HttpResponse response) throws IOException {
            return IOUtils.toString((Reader)new InputStreamReader(entity.getContent(), IO.getCharset()));
        }

        @Override
        public boolean closable() {
            return true;
        }
    };
    public static final HttpClientDeserializer<byte[]> BYTE = new HttpClientDeserializer<byte[]>(){

        @Override
        public byte[] call(HttpEntity entity, HttpResponse response) throws IOException {
            return IOUtils.toByteArray((InputStream)entity.getContent());
        }

        @Override
        public boolean closable() {
            return true;
        }
    };
    public static final HttpClientDeserializer<InputStream> STREAM = new HttpClientDeserializer<InputStream>(){

        @Override
        public InputStream call(HttpEntity entity, HttpResponse response) throws IOException {
            return entity.getContent();
        }

        @Override
        public boolean closable() {
            return false;
        }
    };

    private HttpClientDeserializers() {
    }

    public static <T> HttpClientDeserializer<T> object(Class<T> target, Deserializer deserializer) {
        return new ObjectHttpClientDeserializer<T>(target, deserializer);
    }

    public static HttpClientDeserializer<Response> reponse(final Deserializer deserializer) {
        return new HttpClientDeserializer<Response>(){

            @Override
            public Response call(HttpEntity entity, HttpResponse response) throws IOException {
                return new ResponseImpl(response, deserializer);
            }

            @Override
            public boolean closable() {
                return false;
            }
        };
    }

    public static final class ObjectHttpClientDeserializer<T>
    implements HttpClientDeserializer<T> {
        private final Class<T> target;
        private final Deserializer deserializer;

        public ObjectHttpClientDeserializer(Class<T> target, Deserializer deserializer) {
            this.target = target;
            this.deserializer = deserializer;
        }

        @Override
        public T call(HttpEntity entity, HttpResponse response) throws IOException {
            Deserializer d = this.deserializer;
            if (entity != null) {
                if (d == null) {
                    d = IO.deserializer((String)response.getLastHeader("Content-Type").getValue(), this.target);
                }
                if (d != null) {
                    return (T)d.toObject(entity.getContent(), this.target);
                }
                LogFactory.getLog(this.getClass()).warn((Object)"no deserializer found");
            }
            return null;
        }

        @Override
        public boolean closable() {
            return true;
        }
    }
}

